/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Event;
import com.fluendo.jst.Pad;
import com.fluendo.jtiger.Renderer;
import com.fluendo.plugin.Overlay;
import com.fluendo.utils.Debug;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;

public class KateOverlay
extends Overlay {
    private BufferedImage bimg = null;
    private Font font = null;
    private String text = null;
    private Renderer tr = new Renderer();
    private Pad kateSinkPad = new Pad(2, "katesink"){

        protected boolean eventFunc(Event event) {
            return true;
        }

        protected synchronized int chainFunc(Buffer buffer) {
            KateOverlay.this.addKateEvent((com.fluendo.jkate.Event)buffer.object);
            return 0;
        }
    };

    public KateOverlay() {
        this.addPad(this.kateSinkPad);
    }

    protected synchronized void addKateEvent(com.fluendo.jkate.Event event) {
        this.tr.add(event);
        Debug.log(4, "Kate overlay got Kate event: " + new String(event.text));
    }

    protected synchronized void overlay(Buffer buffer) {
        Image image;
        if (buffer.object instanceof ImageProducer) {
            image = this.component.createImage((ImageProducer)buffer.object);
        } else if (buffer.object instanceof Image) {
            image = (Image)buffer.object;
        } else {
            System.out.println(this + ": unknown buffer received " + buffer);
            return;
        }
        int n = this.tr.update(this.component, (double)buffer.timestamp / 1000000.0);
        if (n == 1) {
            return;
        }
        Dimension dimension = this.component.getSize();
        int n2 = 0;
        int n3 = 0;
        int n4 = dimension.width;
        int n5 = dimension.height;
        if (this.bimg == null || this.bimg.getWidth() != n4 || this.bimg.getHeight() != n5) {
            this.bimg = this.component.getGraphicsConfiguration().createCompatibleImage(n4, n5);
        }
        Graphics2D graphics2D = this.bimg.createGraphics();
        graphics2D.drawImage(image, n2, n3, n4, n5, null);
        this.tr.render(this.component, this.bimg);
        graphics2D.dispose();
        buffer.object = this.bimg;
    }

    public String getFactoryName() {
        return "kateoverlay";
    }
}

