/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableFObj;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.TableColLength;
import org.apache.fop.layoutmgr.table.CollapsingBorderModel;
import org.xml.sax.Locator;

public class TableColumn
extends TableFObj {
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private int columnNumber;
    private Length columnWidth;
    private int numberColumnsRepeated;
    private int numberColumnsSpanned;
    private boolean implicitColumn;
    private PropertyList pList = null;

    public TableColumn(FONode parent) {
        this(parent, false);
    }

    public TableColumn(FONode parent, boolean implicit) {
        super(parent);
        this.implicitColumn = implicit;
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.columnNumber = pList.get(70).getNumeric().getValue();
        this.columnWidth = pList.get(71).getLength();
        this.numberColumnsRepeated = pList.get(148).getNumeric().getValue();
        this.numberColumnsSpanned = pList.get(149).getNumeric().getValue();
        super.bind(pList);
        if (this.numberColumnsRepeated <= 0) {
            throw new PropertyException("number-columns-repeated must be 1 or bigger, but got " + this.numberColumnsRepeated);
        }
        if (this.numberColumnsSpanned <= 0) {
            throw new PropertyException("number-columns-spanned must be 1 or bigger, but got " + this.numberColumnsSpanned);
        }
        if (this.columnWidth.getEnum() == 9) {
            if (!this.implicitColumn && !this.getTable().isAutoLayout()) {
                log.warn("table-layout=\"fixed\" and column-width unspecified => falling back to proportional-column-width(1)");
            }
            this.columnWidth = new TableColLength(1.0, this);
        }
        if (!this.implicitColumn) {
            this.pList = pList;
        }
    }

    public void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().startColumn(this);
    }

    void setCollapsedBorders(CollapsingBorderModel collapsingBorderModel) {
        this.collapsingBorderModel = collapsingBorderModel;
        this.setCollapsedBorders();
    }

    protected void setCollapsedBorders() {
        Table table = (Table)this.parent;
        this.createBorder(0, table);
        this.createBorder(1, table);
        this.createBorder(2);
        this.createBorder(3);
    }

    public void endOfNode() throws FOPException {
        this.getFOEventHandler().endColumn(this);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        this.invalidChildError(loc, nsURI, localName);
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public Length getColumnWidth() {
        return this.columnWidth;
    }

    public void setColumnWidth(Length columnWidth) {
        this.columnWidth = columnWidth;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    protected void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    public int getNumberColumnsRepeated() {
        return this.numberColumnsRepeated;
    }

    public int getNumberColumnsSpanned() {
        return this.numberColumnsSpanned;
    }

    public String getLocalName() {
        return "table-column";
    }

    public int getNameId() {
        return 51;
    }

    public boolean isImplicitColumn() {
        return this.implicitColumn;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("fo:table-column");
        sb.append(" column-number=").append(this.getColumnNumber());
        if (this.getNumberColumnsRepeated() > 1) {
            sb.append(" number-columns-repeated=").append(this.getNumberColumnsRepeated());
        }
        if (this.getNumberColumnsSpanned() > 1) {
            sb.append(" number-columns-spanned=").append(this.getNumberColumnsSpanned());
        }
        sb.append(" column-width=").append(this.getColumnWidth());
        return sb.toString();
    }

    public Property getProperty(int propId) throws PropertyException {
        return this.pList.get(propId);
    }

    protected void releasePropertyList() {
        this.pList = null;
    }
}

