/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.table.EffRow;
import org.apache.fop.fo.flow.table.PrimaryGridUnit;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableBody;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.table.ColumnSetup;
import org.apache.fop.layoutmgr.table.RowGroupLayoutManager;
import org.apache.fop.layoutmgr.table.RowPainter;
import org.apache.fop.layoutmgr.table.TableContentPosition;
import org.apache.fop.layoutmgr.table.TableHFPenaltyPosition;
import org.apache.fop.layoutmgr.table.TableHeaderFooterPosition;
import org.apache.fop.layoutmgr.table.TableLayoutManager;
import org.apache.fop.layoutmgr.table.TableRowIterator;
import org.apache.fop.layoutmgr.table.TableStepper;
import org.apache.fop.util.BreakUtil;

public class TableContentLayoutManager
implements PercentBaseContext {
    private static Log log = LogFactory.getLog(TableContentLayoutManager.class);
    private TableLayoutManager tableLM;
    private TableRowIterator bodyIter;
    private TableRowIterator headerIter;
    private TableRowIterator footerIter;
    private LinkedList headerList;
    private LinkedList footerList;
    private int headerNetHeight = 0;
    private int footerNetHeight = 0;
    private int startXOffset;
    private int usedBPD;
    private TableStepper stepper;

    TableContentLayoutManager(TableLayoutManager parent) {
        this.tableLM = parent;
        Table table = this.getTableLM().getTable();
        this.bodyIter = new TableRowIterator(table, 0);
        if (table.getTableHeader() != null) {
            this.headerIter = new TableRowIterator(table, 1);
        }
        if (table.getTableFooter() != null) {
            this.footerIter = new TableRowIterator(table, 2);
        }
        this.stepper = new TableStepper(this);
    }

    TableLayoutManager getTableLM() {
        return this.tableLM;
    }

    boolean isSeparateBorderModel() {
        return this.getTableLM().getTable().isSeparateBorderModel();
    }

    ColumnSetup getColumns() {
        return this.getTableLM().getColumns();
    }

    protected int getHeaderNetHeight() {
        return this.headerNetHeight;
    }

    protected int getFooterNetHeight() {
        return this.footerNetHeight;
    }

    protected LinkedList getHeaderElements() {
        return this.headerList;
    }

    protected LinkedList getFooterElements() {
        return this.footerList;
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        KnuthBox box;
        TableHeaderFooterPosition pos;
        if (log.isDebugEnabled()) {
            log.debug("==> Columns: " + this.getTableLM().getColumns());
        }
        KnuthBox headerAsFirst = null;
        KnuthBox headerAsSecondToLast = null;
        KnuthBox footerAsLast = null;
        if (this.headerIter != null && this.headerList == null) {
            this.headerList = this.getKnuthElementsForRowIterator(this.headerIter, context, alignment, 1);
            this.headerNetHeight = ElementListUtils.calcContentLength(this.headerList);
            if (log.isDebugEnabled()) {
                log.debug("==> Header: " + this.headerNetHeight + " - " + this.headerList);
            }
            pos = new TableHeaderFooterPosition(this.getTableLM(), true, this.headerList);
            box = new KnuthBox(this.headerNetHeight, pos, false);
            if (this.getTableLM().getTable().omitHeaderAtBreak()) {
                headerAsFirst = box;
            } else {
                headerAsSecondToLast = box;
            }
        }
        if (this.footerIter != null && this.footerList == null) {
            this.footerList = this.getKnuthElementsForRowIterator(this.footerIter, context, alignment, 2);
            this.footerNetHeight = ElementListUtils.calcContentLength(this.footerList);
            if (log.isDebugEnabled()) {
                log.debug("==> Footer: " + this.footerNetHeight + " - " + this.footerList);
            }
            pos = new TableHeaderFooterPosition(this.getTableLM(), false, this.footerList);
            footerAsLast = box = new KnuthBox(this.footerNetHeight, pos, false);
        }
        LinkedList returnList = this.getKnuthElementsForRowIterator(this.bodyIter, context, alignment, 0);
        if (headerAsFirst != null) {
            int insertionPoint = 0;
            if (returnList.size() > 0 && ((ListElement)returnList.getFirst()).isForcedBreak()) {
                ++insertionPoint;
            }
            returnList.add(insertionPoint, headerAsFirst);
        } else if (headerAsSecondToLast != null) {
            int insertionPoint = returnList.size();
            if (returnList.size() > 0 && ((ListElement)returnList.getLast()).isForcedBreak()) {
                --insertionPoint;
            }
            returnList.add(insertionPoint, headerAsSecondToLast);
        }
        if (footerAsLast != null) {
            int insertionPoint = returnList.size();
            if (returnList.size() > 0 && ((ListElement)returnList.getLast()).isForcedBreak()) {
                --insertionPoint;
            }
            returnList.add(insertionPoint, footerAsLast);
        }
        return returnList;
    }

    private LinkedList getKnuthElementsForRowIterator(TableRowIterator iter, LayoutContext context, int alignment, int bodyType) {
        int orphanContentLimit;
        LinkedList<BreakElement> returnList = new LinkedList<BreakElement>();
        EffRow[] rowGroup = iter.getNextRowGroup();
        context.unsetFlags(1536);
        context.setBreakBefore(9);
        context.setBreakAfter(9);
        boolean keepWithPrevious = false;
        int breakBefore = 9;
        if (rowGroup != null) {
            RowGroupLayoutManager rowGroupLM = new RowGroupLayoutManager(this.getTableLM(), rowGroup, this.stepper);
            LinkedList nextRowGroupElems = rowGroupLM.getNextKnuthElements(context, alignment, bodyType);
            keepWithPrevious = context.isKeepWithPreviousPending();
            boolean keepBetween = context.isKeepWithNextPending();
            breakBefore = context.getBreakBefore();
            int breakBetween = context.getBreakAfter();
            returnList.addAll(nextRowGroupElems);
            while ((rowGroup = iter.getNextRowGroup()) != null) {
                rowGroupLM = new RowGroupLayoutManager(this.getTableLM(), rowGroup, this.stepper);
                nextRowGroupElems = rowGroupLM.getNextKnuthElements(context, alignment, bodyType);
                int penaltyValue = 0;
                if ((keepBetween |= context.isKeepWithPreviousPending()) || this.tableLM.getTable().mustKeepTogether()) {
                    penaltyValue = 1000;
                }
                if ((breakBetween = BreakUtil.compareBreakClasses(breakBetween, context.getBreakBefore())) != 9) {
                    penaltyValue = -1000;
                }
                TableHFPenaltyPosition penaltyPos = new TableHFPenaltyPosition(this.getTableLM());
                int penaltyLen = 0;
                if (bodyType == 0) {
                    if (!this.getTableLM().getTable().omitHeaderAtBreak()) {
                        penaltyLen += this.getHeaderNetHeight();
                        penaltyPos.headerElements = this.getHeaderElements();
                    }
                    if (!this.getTableLM().getTable().omitFooterAtBreak()) {
                        penaltyLen += this.getFooterNetHeight();
                        penaltyPos.footerElements = this.getFooterElements();
                    }
                }
                returnList.add(new BreakElement(penaltyPos, penaltyLen, penaltyValue, breakBetween, context));
                returnList.addAll(nextRowGroupElems);
                breakBetween = context.getBreakAfter();
                keepBetween = context.isKeepWithNextPending();
            }
        }
        context.setFlags(1024, keepWithPrevious);
        context.setBreakBefore(breakBefore);
        int widowContentLimit = this.getTableLM().getTable().getWidowContentLimit().getValue();
        if (widowContentLimit != 0 && bodyType == 0) {
            ElementListUtils.removeLegalBreaks(returnList, widowContentLimit);
        }
        if ((orphanContentLimit = this.getTableLM().getTable().getOrphanContentLimit().getValue()) != 0 && bodyType == 0) {
            ElementListUtils.removeLegalBreaksFromEnd(returnList, orphanContentLimit);
        }
        return returnList;
    }

    protected int getXOffsetOfGridUnit(PrimaryGridUnit gu) {
        int col = gu.getColIndex();
        return this.startXOffset + this.getTableLM().getColumns().getXOffset(col + 1, this.getTableLM());
    }

    void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        Map markers;
        this.usedBPD = 0;
        RowPainter painter = new RowPainter(this, layoutContext);
        ArrayList<Position> tablePositions = new ArrayList<Position>();
        List headerElements = null;
        List footerElements = null;
        Position firstPos = null;
        Position lastPos = null;
        Position lastCheckPos = null;
        while (parentIter.hasNext()) {
            Position pos = (Position)parentIter.next();
            if (pos instanceof SpaceResolver.SpaceHandlingBreakPosition) {
                pos = ((SpaceResolver.SpaceHandlingBreakPosition)pos).getOriginalBreakPosition();
            }
            if (pos == null) continue;
            if (firstPos == null) {
                firstPos = pos;
            }
            lastPos = pos;
            if (pos.getIndex() >= 0) {
                lastCheckPos = pos;
            }
            if (pos instanceof TableHeaderFooterPosition) {
                TableHeaderFooterPosition thfpos = (TableHeaderFooterPosition)pos;
                if (thfpos.header) {
                    headerElements = thfpos.nestedElements;
                    continue;
                }
                footerElements = thfpos.nestedElements;
                continue;
            }
            if (pos instanceof TableHFPenaltyPosition) continue;
            if (pos instanceof TableContentPosition) {
                tablePositions.add(pos);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Ignoring position: " + pos);
        }
        if (lastPos instanceof TableHFPenaltyPosition) {
            TableHFPenaltyPosition penaltyPos = (TableHFPenaltyPosition)lastPos;
            log.debug("Break at penalty!");
            if (penaltyPos.headerElements != null) {
                headerElements = penaltyPos.headerElements;
            }
            if (penaltyPos.footerElements != null) {
                footerElements = penaltyPos.footerElements;
            }
        }
        if ((markers = this.getTableLM().getTable().getMarkers()) != null) {
            this.getTableLM().getCurrentPV().addMarkers(markers, true, this.getTableLM().isFirst(firstPos), this.getTableLM().isLast(lastCheckPos));
        }
        if (headerElements != null) {
            this.addHeaderFooterAreas(headerElements, this.tableLM.getTable().getTableHeader(), painter, false);
        }
        if (tablePositions.isEmpty()) {
            log.error("tablePositions empty. Please send your FO file to fop-users@xmlgraphics.apache.org");
        } else {
            this.addBodyAreas(tablePositions.iterator(), painter, footerElements == null);
        }
        if (footerElements != null) {
            this.addHeaderFooterAreas(footerElements, this.tableLM.getTable().getTableFooter(), painter, true);
        }
        this.usedBPD += painter.getAccumulatedBPD();
        if (markers != null) {
            this.getTableLM().getCurrentPV().addMarkers(markers, false, this.getTableLM().isFirst(firstPos), this.getTableLM().isLast(lastCheckPos));
        }
    }

    private void addHeaderFooterAreas(List elements, TableBody part, RowPainter painter, boolean lastOnPage) {
        ArrayList<TableContentPosition> lst = new ArrayList<TableContentPosition>(elements.size());
        KnuthPossPosIter iter = new KnuthPossPosIter(elements);
        while (iter.hasNext()) {
            Position pos = (Position)iter.next();
            if (!(pos instanceof TableContentPosition)) continue;
            lst.add((TableContentPosition)pos);
        }
        this.addTablePartAreas(lst, painter, part, true, true, true, lastOnPage);
    }

    private void addBodyAreas(Iterator iterator, RowPainter painter, boolean lastOnPage) {
        painter.startBody();
        ArrayList<TableContentPosition> lst = new ArrayList<TableContentPosition>();
        TableContentPosition pos = (TableContentPosition)iterator.next();
        boolean isFirstPos = pos.getFlag(1) && pos.getRow().getFlag(0);
        TableBody body = pos.getTableBody();
        lst.add(pos);
        while (iterator.hasNext()) {
            pos = (TableContentPosition)iterator.next();
            if (pos.getTableBody() != body) {
                this.addTablePartAreas(lst, painter, body, isFirstPos, true, false, false);
                isFirstPos = true;
                lst.clear();
                body = pos.getTableBody();
            }
            lst.add(pos);
        }
        boolean isLastPos = pos.getFlag(2) && pos.getRow().getFlag(1);
        this.addTablePartAreas(lst, painter, body, isFirstPos, isLastPos, true, lastOnPage);
        painter.endBody();
    }

    private void addTablePartAreas(List positions, RowPainter painter, TableBody body, boolean isFirstPos, boolean isLastPos, boolean lastInBody, boolean lastOnPage) {
        this.getTableLM().getCurrentPV().addMarkers(body.getMarkers(), true, isFirstPos, isLastPos);
        painter.startTablePart(body);
        Iterator iter = positions.iterator();
        while (iter.hasNext()) {
            painter.handleTableContentPosition((TableContentPosition)iter.next());
        }
        this.getTableLM().getCurrentPV().addMarkers(body.getMarkers(), false, isFirstPos, isLastPos);
        painter.endTablePart(lastInBody, lastOnPage);
    }

    void setStartXOffset(int startXOffset) {
        this.startXOffset = startXOffset;
    }

    int getUsedBPD() {
        return this.usedBPD;
    }

    public int getBaseLength(int lengthBase, FObj fobj) {
        return this.tableLM.getBaseLength(lengthBase, fobj);
    }
}

