/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.ImageSource;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.image.loader.util.SoftMapCache;

public abstract class AbstractImageSessionContext
implements ImageSessionContext {
    private static Log log;
    private SoftMapCache sessionSources = new SoftMapCache(false);
    static final /* synthetic */ boolean $assertionsDisabled;

    protected abstract Source resolveURI(String var1);

    public Source newSource(String uri) {
        URL url;
        Source source = this.resolveURI(uri);
        if (source == null) {
            if (log.isDebugEnabled()) {
                log.debug("URI could not be resolved: " + uri);
            }
            return null;
        }
        if (!(source instanceof StreamSource) && !(source instanceof SAXSource)) {
            return source;
        }
        ImageSource imageSource = null;
        String resolvedURI = source.getSystemId();
        try {
            url = new URL(resolvedURI);
        }
        catch (MalformedURLException e) {
            url = null;
        }
        File f = FileUtils.toFile(url);
        if (f != null) {
            boolean directFileAccess = true;
            if (!($assertionsDisabled || source instanceof StreamSource || source instanceof SAXSource)) {
                throw new AssertionError();
            }
            InputStream in = ImageUtil.getInputStream(source);
            if (in == null) {
                try {
                    in = new FileInputStream(f);
                }
                catch (FileNotFoundException fnfe) {
                    log.error("Error while opening file. Could not load image from system identifier '" + source.getSystemId() + "' (" + fnfe.getMessage() + ")");
                    return null;
                }
            }
            if (in != null) {
                in = ImageUtil.decorateMarkSupported(in);
                try {
                    if (ImageUtil.isGZIPCompressed(in)) {
                        directFileAccess = false;
                    }
                }
                catch (IOException ioe) {
                    log.error("Error while checking the InputStream for GZIP compression. Could not load image from system identifier '" + source.getSystemId() + "' (" + ioe.getMessage() + ")");
                    return null;
                }
            }
            if (directFileAccess) {
                IOUtils.closeQuietly(in);
                try {
                    imageSource = new ImageSource(ImageIO.createImageInputStream(f), resolvedURI, true);
                }
                catch (IOException ioe) {
                    log.error("Unable to create ImageInputStream for local file from system identifier '" + source.getSystemId() + "' (" + ioe.getMessage() + ")");
                }
            }
        }
        if (imageSource == null) {
            if (ImageUtil.hasReader(source) && !ImageUtil.hasInputStream(source)) {
                return source;
            }
            InputStream in = ImageUtil.getInputStream(source);
            if (in == null && url != null) {
                try {
                    in = url.openStream();
                }
                catch (Exception ex) {
                    log.error("Unable to obtain stream from system identifier '" + source.getSystemId() + "'");
                }
            }
            if (in == null) {
                log.error("The Source that was returned from URI resolution didn't contain an InputStream for URI: " + uri);
                return null;
            }
            try {
                in = ImageUtil.autoDecorateInputStream(in);
                imageSource = new ImageSource(ImageIO.createImageInputStream(in), source.getSystemId(), false);
            }
            catch (IOException ioe) {
                log.error("Unable to create ImageInputStream for InputStream from system identifier '" + source.getSystemId() + "' (" + ioe.getMessage() + ")");
            }
        }
        return imageSource;
    }

    public Source getSource(String uri) {
        return (Source)this.sessionSources.remove(uri);
    }

    public Source needSource(String uri) throws FileNotFoundException {
        Source src = this.getSource(uri);
        if (src == null) {
            if (log.isDebugEnabled()) {
                log.debug("Creating new Source for " + uri);
            }
            if ((src = this.newSource(uri)) == null) {
                throw new FileNotFoundException("Image not found: " + uri);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Reusing Source for " + uri);
        }
        return src;
    }

    public void returnSource(String uri, Source src) {
        ImageInputStream in = ImageUtil.getImageInputStream(src);
        try {
            if (in != null && in.getStreamPosition() != 0L) {
                throw new IllegalStateException("ImageInputStream is not reset for: " + uri);
            }
        }
        catch (IOException ioe) {
            ImageUtil.closeQuietly(src);
        }
        if (this.isReusable(src)) {
            log.debug("Returning Source for " + uri);
            this.sessionSources.put(uri, src);
        } else {
            ImageUtil.closeQuietly(src);
        }
    }

    protected boolean isReusable(Source src) {
        ImageSource is;
        if (src instanceof ImageSource && (is = (ImageSource)src).getImageInputStream() != null) {
            return true;
        }
        return src instanceof DOMSource;
    }

    static {
        $assertionsDisabled = !AbstractImageSessionContext.class.desiredAssertionStatus();
        log = LogFactory.getLog(AbstractImageSessionContext.class);
    }
}

