/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import jaxe.Config;
import jaxe.JaxeResourceBundle;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class DialogueAideElement
extends JDialog
implements ActionListener {
    private static final Logger LOG = Logger.getLogger(DialogueAideElement.class);
    private static final ResourceBundle rb = JaxeResourceBundle.getRB();
    private Element refNoeud;
    private Element refElementParent;
    private final Config cfg;
    private JLabel labelTitre;
    private JLabel labeldoc;
    private JList listeParents;
    private JList listeEnfants;
    private JList listeAttributs;
    private JLabel labelexpr;
    private ArrayList<Element> refElementsParents;
    private ArrayList<Element> refElementsEnfants;
    private ArrayList<Element> refAttributs;
    private boolean aideAttribut;
    private JTabbedPane onglets;
    private JPanel ongletEnfants;
    private JPanel ongletAttributs;

    public DialogueAideElement(Element element, Config config, JFrame jFrame) {
        super(jFrame, rb.getString("aide.element") + " " + config.nomElement(element), true);
        this.cfg = config;
        this.refElementParent = null;
        this.aideAttribut = false;
        this.initialisation(jFrame);
        this.remplissage(element);
    }

    public DialogueAideElement(Element element, Element element2, Config config, JFrame jFrame) {
        super(jFrame, rb.getString("aide.attribut") + " " + config.nomAttribut(element), true);
        this.cfg = config;
        this.refElementParent = element2;
        this.aideAttribut = true;
        this.initialisation(jFrame);
        this.remplissage(element);
    }

    private void initialisation(JFrame jFrame) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel();
        this.labelTitre = new JLabel();
        this.labelTitre.setFont(new Font("SansSerif", 1, 14));
        jPanel2.add(this.labelTitre);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(new Dimension(1, 20)));
        JLabel jLabel = new JLabel(rb.getString("aide.description"));
        jLabel.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        this.labeldoc = new JLabel("");
        JPanel jPanel3 = new JPanel();
        jPanel3.setAlignmentX(0.0f);
        jPanel3.add(this.labeldoc);
        jPanel.add(jPanel3);
        jPanel.add(Box.createRigidArea(new Dimension(1, 20)));
        this.onglets = new JTabbedPane();
        this.onglets.setAlignmentX(0.0f);
        jPanel.add(this.onglets);
        DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                jLabel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
                return jLabel;
            }
        };
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        JLabel jLabel2 = new JLabel(rb.getString("aide.parents"));
        jLabel2.setAlignmentX(0.0f);
        jPanel4.add(jLabel2);
        this.listeParents = new JList();
        this.listeParents.setCellRenderer(defaultListCellRenderer);
        this.listeParents.setLayoutOrientation(2);
        this.listeParents.setVisibleRowCount(-1);
        this.listeParents.setSelectionMode(0);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = DialogueAideElement.this.listeParents.locationToIndex(mouseEvent.getPoint())) != -1) {
                    if (DialogueAideElement.this.aideAttribut) {
                        DialogueAideElement.this.onglets.setSelectedIndex(2);
                        DialogueAideElement.this.aideAttribut = false;
                    }
                    DialogueAideElement.this.remplissage((Element)DialogueAideElement.this.refElementsParents.get(n));
                }
            }
        };
        this.listeParents.addMouseListener(mouseAdapter);
        JScrollPane jScrollPane = new JScrollPane(this.listeParents, 20, 31);
        jScrollPane.setPreferredSize(new Dimension(400, 200));
        jScrollPane.setAlignmentX(0.0f);
        jPanel4.add(jScrollPane);
        this.onglets.add(rb.getString("aide.parents"), jPanel4);
        this.ongletEnfants = new JPanel();
        this.ongletEnfants.setLayout(new BoxLayout(this.ongletEnfants, 1));
        JLabel jLabel3 = new JLabel(rb.getString("aide.enfants"));
        jLabel3.setAlignmentX(0.0f);
        this.ongletEnfants.add(jLabel3);
        this.labelexpr = new JLabel("");
        this.labelexpr.setAlignmentX(0.0f);
        this.ongletEnfants.add(this.labelexpr);
        this.listeEnfants = new JList();
        this.listeEnfants.setCellRenderer(defaultListCellRenderer);
        this.listeEnfants.setLayoutOrientation(2);
        this.listeEnfants.setVisibleRowCount(-1);
        this.listeEnfants.setSelectionMode(0);
        MouseAdapter mouseAdapter2 = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = DialogueAideElement.this.listeEnfants.locationToIndex(mouseEvent.getPoint())) != -1) {
                    DialogueAideElement.this.remplissage((Element)DialogueAideElement.this.refElementsEnfants.get(n));
                }
            }
        };
        this.listeEnfants.addMouseListener(mouseAdapter2);
        JScrollPane jScrollPane2 = new JScrollPane(this.listeEnfants, 20, 31);
        jScrollPane2.setPreferredSize(new Dimension(400, 200));
        jScrollPane2.setAlignmentX(0.0f);
        this.ongletEnfants.add(jScrollPane2);
        this.onglets.add(rb.getString("aide.enfants"), this.ongletEnfants);
        this.ongletAttributs = new JPanel();
        this.ongletAttributs.setLayout(new BoxLayout(this.ongletAttributs, 1));
        JLabel jLabel4 = new JLabel(rb.getString("aide.attributs"));
        jLabel4.setAlignmentX(0.0f);
        this.ongletAttributs.add(jLabel4);
        this.listeAttributs = new JList();
        this.listeAttributs.setCellRenderer(defaultListCellRenderer);
        this.listeAttributs.setLayoutOrientation(2);
        this.listeAttributs.setVisibleRowCount(-1);
        this.listeAttributs.setSelectionMode(0);
        MouseAdapter mouseAdapter3 = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = DialogueAideElement.this.listeAttributs.locationToIndex(mouseEvent.getPoint())) != -1) {
                    DialogueAideElement.this.aideAttribut = true;
                    DialogueAideElement.this.refElementParent = DialogueAideElement.this.refNoeud;
                    DialogueAideElement.this.onglets.setSelectedIndex(0);
                    DialogueAideElement.this.remplissage((Element)DialogueAideElement.this.refAttributs.get(n));
                }
            }
        };
        this.listeAttributs.addMouseListener(mouseAdapter3);
        JScrollPane jScrollPane3 = new JScrollPane(this.listeAttributs, 20, 31);
        jScrollPane3.setPreferredSize(new Dimension(400, 200));
        jScrollPane3.setAlignmentX(0.0f);
        this.ongletAttributs.add(jScrollPane3);
        this.onglets.add(rb.getString("aide.attributs"), this.ongletAttributs);
        if (this.aideAttribut) {
            this.ongletAttributs.setVisible(false);
        }
        this.onglets.setSelectedIndex(1);
        JPanel jPanel5 = new JPanel(new FlowLayout());
        jPanel5.setAlignmentX(0.0f);
        JButton jButton = new JButton(rb.getString("aide.fermer"));
        jButton.setActionCommand("fermer");
        jButton.addActionListener(this);
        jPanel5.add(jButton);
        jPanel.add(jPanel5);
        this.getRootPane().setDefaultButton(jButton);
        if (jFrame != null) {
            Rectangle rectangle = jFrame.getBounds();
            this.setLocation(rectangle.x + rectangle.width / 4, rectangle.y + rectangle.height / 4);
        } else {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getSize().width) / 3, (dimension.height - this.getSize().height) / 3);
        }
    }

    public void remplissage(Element element) {
        int n;
        String[] stringArray;
        this.refNoeud = element;
        if (this.aideAttribut) {
            this.setTitle(rb.getString("aide.attribut") + " " + this.cfg.nomAttribut(element));
        } else {
            this.setTitle(rb.getString("aide.element") + " " + this.cfg.nomElement(element));
        }
        if (this.aideAttribut) {
            this.labelTitre.setText(this.cfg.titreAttribut(this.refElementParent, element));
        } else {
            this.labelTitre.setText(this.cfg.titreElement(element));
        }
        String string = this.aideAttribut ? this.cfg.documentationAttribut(this.refElementParent, element) : this.cfg.documentation(element);
        if (string != null) {
            string = this.cfg.formatageDoc(string);
        }
        this.labeldoc.setText(string);
        this.listeParents.clearSelection();
        if (this.aideAttribut) {
            this.refElementsParents = new ArrayList();
            this.refElementsParents.add(this.refElementParent);
            stringArray = new String[]{this.cfg.titreElement(this.refElementParent)};
            this.listeParents.setListData(stringArray);
        } else {
            this.refElementsParents = this.cfg.listeElementsParents(element);
            stringArray = new String[this.refElementsParents.size()];
            for (n = 0; n < this.refElementsParents.size(); ++n) {
                stringArray[n] = this.cfg.titreElement(this.refElementsParents.get(n));
            }
            this.listeParents.setListData(stringArray);
        }
        this.onglets.setEnabledAt(1, !this.aideAttribut);
        if (!this.aideAttribut) {
            this.labelexpr.setText(this.versHTML(this.cfg.expressionReguliere(element)));
            this.listeEnfants.clearSelection();
            this.refElementsEnfants = this.cfg.listeSousElements(element);
            stringArray = new String[this.refElementsEnfants.size()];
            for (n = 0; n < this.refElementsEnfants.size(); ++n) {
                stringArray[n] = this.cfg.titreElement(this.refElementsEnfants.get(n));
            }
            this.listeEnfants.setListData(stringArray);
        }
        this.onglets.setEnabledAt(2, !this.aideAttribut);
        if (!this.aideAttribut) {
            this.listeAttributs.clearSelection();
            this.refAttributs = this.cfg.listeAttributs(element);
            stringArray = new String[this.refAttributs.size()];
            for (n = 0; n < this.refAttributs.size(); ++n) {
                stringArray[n] = this.cfg.titreAttribut(element, this.refAttributs.get(n));
            }
            this.listeAttributs.setListData(stringArray);
        }
        this.pack();
    }

    protected String versHTML(String string) {
        if (string != null && (string = string.trim()).length() > 90) {
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (i - n <= 80 || string.charAt(i) != '|' && string.charAt(i) != ',') continue;
                string = string.substring(0, i) + "<br>" + string.substring(i);
                n = i;
            }
            string = "<html><body>" + string + "</body></html>";
        }
        return string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("fermer".equals(string)) {
            this.fermer();
        }
    }

    public void fermer() {
        this.setVisible(false);
        this.dispose();
    }
}

