/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import jaxe.DialogueXpath;
import jaxe.JaxeDocument;
import jaxe.JaxeElement;
import jaxe.JaxeResourceBundle;
import jaxe.JaxeTextPane;
import org.apache.log4j.Logger;
import org.w3c.dom.NodeList;

public class DialogueRechercher
extends JDialog
implements ActionListener,
ItemListener {
    private static final Logger LOG = Logger.getLogger(DialogueRechercher.class);
    private static final ResourceBundle rb = JaxeResourceBundle.getRB();
    private final JTextPane textPane;
    private final StyledDocument doc;
    private final JPanel bpane;
    private final JPanel cpane;
    JTextField tfRechercher;
    private final JTextField tfRemplacer;
    private final JLabel textRech = new JLabel(rb.getString("rechercher.Rechercher"));
    private final JLabel textRemp = new JLabel(rb.getString("rechercher.RemplacerPar"));
    private final JButton bXpath;
    private final JButton btout;
    private final JButton bremplacer;
    private final JButton bremplrech;
    JRadioButton bfichier;
    JRadioButton bsel;
    private final JCheckBox typeXpath;
    private final JCheckBox chkmaj;
    private boolean dansSelection = false;
    private boolean ignorerCasse = false;
    public boolean RechXpath = false;
    static String texteRecherche = null;
    static String texteXpathRecherche = null;
    public JaxeDocument Jdoc;

    public DialogueRechercher(JaxeDocument jaxeDocument, JTextPane jTextPane) {
        super((JFrame)jTextPane.getTopLevelAncestor(), rb.getString("rechercher.Rechercher"), false);
        this.textPane = jTextPane;
        this.Jdoc = jaxeDocument;
        this.doc = jTextPane.getStyledDocument();
        if (jTextPane.getSelectionEnd() != jTextPane.getSelectionStart()) {
            this.dansSelection = true;
        }
        this.cpane = new JPanel();
        this.cpane.setLayout(new BoxLayout(this.cpane, 1));
        this.setContentPane(this.cpane);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        jPanel2.add(this.textRech);
        jPanel2.add(this.textRemp);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1));
        this.tfRechercher = new JTextField("", 40);
        if (texteRecherche != null) {
            this.tfRechercher.setText(texteRecherche);
        }
        this.tfRechercher.selectAll();
        jPanel3.add(this.tfRechercher);
        this.tfRemplacer = new JTextField("", 40);
        jPanel3.add(this.tfRemplacer);
        this.bpane = new JPanel(new GridLayout(2, 1));
        this.bpane.setPreferredSize(new Dimension(85, 50));
        this.bXpath = new JButton(rb.getString("rechercher.Xpath"));
        this.bXpath.setActionCommand("xpath");
        this.bXpath.addActionListener(this);
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "Center");
        jPanel.add((Component)this.bpane, "East");
        this.cpane.add(jPanel);
        JPanel jPanel4 = new JPanel(new FlowLayout());
        this.bfichier = new JRadioButton(rb.getString("rechercher.FichierEntier"));
        this.bfichier.setActionCommand("fichier");
        this.bfichier.setSelected(!this.dansSelection);
        this.bsel = new JRadioButton(rb.getString("rechercher.Selection"));
        this.bsel.setActionCommand("selection");
        this.bsel.setSelected(this.dansSelection);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.bfichier);
        buttonGroup.add(this.bsel);
        this.bfichier.addActionListener(this);
        this.bsel.addActionListener(this);
        jPanel4.add(this.bfichier);
        jPanel4.add(this.bsel);
        this.chkmaj = new JCheckBox(rb.getString("rechercher.IgnorerCasse"));
        this.chkmaj.addItemListener(this);
        jPanel4.add(this.chkmaj);
        jPanel4.add(Box.createHorizontalStrut(50));
        if (jTextPane instanceof JaxeTextPane) {
            this.typeXpath = new JCheckBox(rb.getString("rechercher.ExprXpath"));
            this.typeXpath.addItemListener(this);
            jPanel4.add(this.typeXpath);
        } else {
            this.typeXpath = null;
        }
        this.cpane.add(jPanel4);
        JPanel jPanel5 = new JPanel(new FlowLayout());
        this.btout = new JButton(rb.getString("rechercher.ToutRemplacer"));
        this.btout.setActionCommand("tout");
        this.btout.addActionListener(this);
        jPanel5.add(this.btout);
        this.bremplacer = new JButton(rb.getString("rechercher.Remplacer"));
        this.bremplacer.setActionCommand("remplacer");
        this.bremplacer.addActionListener(this);
        jPanel5.add(this.bremplacer);
        this.bremplrech = new JButton(rb.getString("rechercher.RemplRech"));
        this.bremplrech.setActionCommand("remplrech");
        this.bremplrech.addActionListener(this);
        jPanel5.add(this.bremplrech);
        JButton jButton = new JButton(rb.getString("rechercher.Precedent"));
        jButton.setActionCommand("precedent");
        jButton.addActionListener(this);
        jPanel5.add(jButton);
        JButton jButton2 = new JButton(rb.getString("rechercher.Suivant"));
        jButton2.setActionCommand("suivant");
        jButton2.addActionListener(this);
        jPanel5.add(jButton2);
        this.cpane.add(jPanel5);
        this.getRootPane().setDefaultButton(jButton2);
        this.addWindowListener(new WindowAdapter(){
            boolean gotFocus = false;

            public void windowActivated(WindowEvent windowEvent) {
                if (!this.gotFocus) {
                    DialogueRechercher.this.tfRechercher.requestFocus();
                    this.gotFocus = true;
                }
            }
        });
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.setVisible(true);
        this.setResizable(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("suivant".equals(string)) {
            if (!this.RechXpath) {
                this.suivant();
            } else {
                this.suivantXpath();
            }
        } else if ("precedent".equals(string)) {
            if (!this.RechXpath) {
                this.precedent();
            } else {
                this.precedentXpath();
            }
        } else if ("remplacer".equals(string)) {
            this.remplacer();
        } else if ("tout".equals(string)) {
            this.toutRemplacer();
        } else if ("remplrech".equals(string)) {
            this.remplRech();
        } else if ("fichier".equals(string)) {
            this.dansSelection = false;
        } else if ("selection".equals(string)) {
            this.dansSelection = true;
        } else if ("xpath".equals(string)) {
            this.setVisible(false);
            if (this.Jdoc.cfg != null) {
                DialogueXpath dialogueXpath = new DialogueXpath(this, this.Jdoc);
            } else {
                JOptionPane.showMessageDialog(this, rb.getString("rechercher.ErrConfig"), rb.getString("rechercher.ExprXpath"), 1);
                this.setVisible(true);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.chkmaj) {
            boolean bl = this.ignorerCasse = itemEvent.getStateChange() == 1;
        }
        if (itemEvent.getSource() == this.typeXpath) {
            boolean bl = this.RechXpath = itemEvent.getStateChange() == 1;
            if (this.RechXpath) {
                this.enableButton(false);
                this.bpane.add(this.bXpath);
            } else {
                this.enableButton(true);
                this.setTitle(rb.getString("rechercher.Rechercher"));
                this.bpane.remove(this.bXpath);
            }
            this.cpane.updateUI();
            this.pack();
        }
    }

    public void enableButton(boolean bl) {
        this.btout.setEnabled(bl);
        this.bremplacer.setEnabled(bl);
        this.bremplrech.setEnabled(bl);
        this.tfRemplacer.setEditable(bl);
        this.bfichier.setEnabled(bl);
        this.bsel.setEnabled(bl);
        this.chkmaj.setEnabled(bl);
        if (bl) {
            this.tfRechercher.setText(texteRecherche);
        } else {
            this.tfRechercher.setText(texteXpathRecherche);
        }
    }

    public void rechercher() {
        texteRecherche = this.tfRechercher.getText();
        if (texteRecherche == null || texteRecherche.length() == 0) {
            return;
        }
        int n = texteRecherche.length();
        int n2 = -1;
        try {
            for (int i = 0; i < this.doc.getLength() - n; ++i) {
                String string = this.doc.getText(i, n);
                if (!string.equals(texteRecherche)) continue;
                n2 = i;
                break;
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.error("rechercher() - BadLocationException", badLocationException);
            return;
        }
        if (n2 != -1) {
            this.textPane.setCaretPosition(n2);
            this.textPane.moveCaretPosition(n2 + n);
        } else {
            this.getToolkit().beep();
        }
    }

    public void suivantXpath() {
        this.suivantXpath(this.textPane.getCaretPosition());
    }

    public void suivantXpath(int n) {
        String string = "";
        int n2 = n;
        texteXpathRecherche = this.tfRechercher.getText();
        if (texteXpathRecherche == null || texteXpathRecherche.length() == 0) {
            return;
        }
        NodeList nodeList = this.getXpathNodeList(this.tfRechercher.getText());
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                int n3;
                JaxeElement jaxeElement = this.Jdoc.getElementForNode(nodeList.item(i));
                if (jaxeElement == null || (n3 = jaxeElement.debut.getOffset()) <= n) continue;
                n2 = n3;
                string = rb.getString("rechercher.nbXpath").replace("NUMRESULT", Integer.toString(i + 1));
                string = string.replace("NBTOTAL", Integer.toString(nodeList.getLength()));
                this.setTitle(rb.getString("rechercher.Rechercher") + " " + string);
                break;
            }
            if (nodeList.getLength() > 0 && n2 == n) {
                string = rb.getString("rechercher.nbXpath").replace("NUMRESULT", "1");
                string = string.replace("NBTOTAL", Integer.toString(nodeList.getLength()));
                this.setTitle(rb.getString("rechercher.Rechercher") + " " + string);
                JaxeElement jaxeElement = this.Jdoc.getElementForNode(nodeList.item(0));
                if (jaxeElement != null) {
                    n2 = jaxeElement.debut.getOffset();
                }
            }
            if (nodeList.getLength() != 0) {
                try {
                    this.textPane.scrollRectToVisible(this.textPane.modelToView(this.doc.getLength()));
                    this.textPane.scrollRectToVisible(this.textPane.modelToView(n2));
                }
                catch (BadLocationException badLocationException) {
                    LOG.error("suivantXpath(int)", badLocationException);
                    return;
                }
                this.textPane.setCaretPosition(n2);
            } else {
                this.getToolkit().beep();
                this.setTitle(rb.getString("rechercher.Rechercher"));
            }
        }
        this.toFront();
    }

    public void precedentXpath() {
        this.precedentXpath(this.textPane.getCaretPosition());
    }

    public void precedentXpath(int n) {
        String string = "";
        int n2 = n;
        texteXpathRecherche = this.tfRechercher.getText();
        if (texteXpathRecherche == null || texteXpathRecherche.length() == 0) {
            return;
        }
        NodeList nodeList = this.getXpathNodeList(this.tfRechercher.getText());
        if (nodeList != null) {
            for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                int n3;
                JaxeElement jaxeElement = this.Jdoc.getElementForNode(nodeList.item(i));
                if (jaxeElement == null || (n3 = jaxeElement.debut.getOffset()) >= n) continue;
                n2 = n3;
                string = rb.getString("rechercher.nbXpath").replace("NUMRESULT", Integer.toString(i + 1));
                string = string.replace("NBTOTAL", Integer.toString(nodeList.getLength()));
                this.setTitle(rb.getString("rechercher.Rechercher") + " " + string);
                break;
            }
            if (nodeList.getLength() > 0 && n2 == n) {
                string = rb.getString("rechercher.nbXpath").replace("NUMRESULT", Integer.toString(nodeList.getLength()));
                string = string.replace("NBTOTAL", Integer.toString(nodeList.getLength()));
                this.setTitle(rb.getString("rechercher.Rechercher") + " " + string);
                JaxeElement jaxeElement = this.Jdoc.getElementForNode(nodeList.item(nodeList.getLength() - 1));
                if (jaxeElement != null) {
                    n2 = jaxeElement.debut.getOffset();
                }
            }
            if (nodeList.getLength() != 0) {
                try {
                    this.textPane.scrollRectToVisible(this.textPane.modelToView(this.doc.getLength()));
                    this.textPane.scrollRectToVisible(this.textPane.modelToView(n2));
                }
                catch (BadLocationException badLocationException) {
                    LOG.error("precedentXpath(int)", badLocationException);
                    return;
                }
                this.textPane.setCaretPosition(n2);
            } else {
                this.getToolkit().beep();
                this.setTitle(rb.getString("rechercher.Rechercher"));
            }
        }
    }

    public NodeList getXpathNodeList(String string) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            xPath.setNamespaceContext(new NamespaceContext(){

                public String getNamespaceURI(String string) {
                    ArrayList<String> arrayList = DialogueRechercher.this.Jdoc.cfg.listeEspaces();
                    for (String string2 : arrayList) {
                        if ("".equals(string2) || string == null || !string.equals(DialogueRechercher.this.Jdoc.cfg.prefixeEspace(string2))) continue;
                        return string2;
                    }
                    return DialogueRechercher.this.Jdoc.DOMdoc.lookupNamespaceURI(string);
                }

                public String getPrefix(String string) {
                    return DialogueRechercher.this.Jdoc.cfg.prefixeEspace(string);
                }

                public Iterator getPrefixes(String string) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(DialogueRechercher.this.Jdoc.cfg.prefixeEspace(string));
                    return arrayList.iterator();
                }
            });
            return (NodeList)xPath.evaluate(string, this.Jdoc.DOMdoc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            String string2 = xPathExpressionException.getMessage();
            if (string2 == null && xPathExpressionException.getCause() != null) {
                string2 = xPathExpressionException.getCause().getMessage();
            }
            JOptionPane.showMessageDialog(this, string2, rb.getString("rechercher.ErrXpath"), 0);
            return null;
        }
    }

    public void suivant() {
        this.suivant(this.textPane.getSelectionStart());
    }

    public void suivant(int n) {
        texteRecherche = this.tfRechercher.getText();
        if (texteRecherche == null || texteRecherche.length() == 0) {
            return;
        }
        int n2 = texteRecherche.length();
        if (n2 >= this.doc.getLength()) {
            this.getToolkit().beep();
            return;
        }
        if (n + n2 > this.doc.getLength()) {
            n = 0;
        }
        int n3 = -1;
        try {
            if (this.textPane.getSelectionEnd() - this.textPane.getSelectionStart() == n2 && (!this.ignorerCasse && this.doc.getText(n, n2).equals(texteRecherche) || this.ignorerCasse && this.doc.getText(n, n2).equalsIgnoreCase(texteRecherche))) {
                ++n;
            }
            for (int i = n; i < this.doc.getLength() - n2; ++i) {
                if (this.includeComponent(i, n2) == -1) {
                    String string = this.doc.getText(i, n2);
                    if ((this.ignorerCasse || !string.equals(texteRecherche)) && (!this.ignorerCasse || !string.equalsIgnoreCase(texteRecherche))) continue;
                    n3 = i;
                    break;
                }
                i = this.includeComponent(i, n2);
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.error("suivant(int) - BadLocationException", badLocationException);
            return;
        }
        if (n3 != -1) {
            this.textPane.setCaretPosition(n3);
            this.textPane.moveCaretPosition(n3 + n2);
        } else if (n != 0) {
            this.suivant(0);
        } else {
            this.getToolkit().beep();
        }
        this.toFront();
    }

    public void precedent() {
        this.precedent(this.textPane.getSelectionStart());
    }

    public void precedent(int n) {
        texteRecherche = this.tfRechercher.getText();
        if (texteRecherche == null || texteRecherche.length() == 0) {
            return;
        }
        int n2 = texteRecherche.length();
        if (n2 >= this.doc.getLength()) {
            this.getToolkit().beep();
            return;
        }
        int n3 = -1;
        if (n + n2 > this.doc.getLength()) {
            n = this.doc.getLength() - n2;
        }
        if (n < 0) {
            n = 0;
        }
        try {
            if (this.textPane.getSelectionEnd() - this.textPane.getSelectionStart() == n2 && (!this.ignorerCasse && this.doc.getText(n, n2).equals(texteRecherche) || this.ignorerCasse && this.doc.getText(n, n2).equalsIgnoreCase(texteRecherche))) {
                --n;
            }
            for (int i = n; i >= 0; --i) {
                if (this.includeComponent(i, n2) == -1) {
                    String string = this.doc.getText(i, n2);
                    if ((this.ignorerCasse || !string.equals(texteRecherche)) && (!this.ignorerCasse || !string.equalsIgnoreCase(texteRecherche))) continue;
                    n3 = i;
                    break;
                }
                i = this.includeComponent(i, n2) - n2 + 1;
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.error("precedent(int) - BadLocationException", badLocationException);
            return;
        }
        if (n3 != -1) {
            this.textPane.setCaretPosition(n3);
            this.textPane.moveCaretPosition(n3 + n2);
        } else if (n != this.doc.getLength() - n2) {
            this.precedent(this.doc.getLength() - n2);
        } else {
            this.getToolkit().beep();
        }
        this.toFront();
    }

    public void remplacer() {
        String string = this.tfRechercher.getText();
        String string2 = this.tfRemplacer.getText();
        if (this.textPane.getSelectionStart() == this.textPane.getSelectionEnd()) {
            return;
        }
        int n = this.textPane.getSelectionStart();
        int n2 = this.textPane.getSelectionEnd();
        try {
            if (!string.equals("")) {
                this.textPane.setSelectionStart(0);
                this.textPane.setSelectionEnd(0);
                int n3 = string.length();
                int n4 = string2.length();
                int n5 = n2 - n3 + 1;
                for (int i = n; i < n5; ++i) {
                    if ((this.ignorerCasse || !string.equals(this.doc.getText(i, n3))) && (!this.ignorerCasse || !string.equalsIgnoreCase(this.doc.getText(i, n3)))) continue;
                    if (this.includeComponent(i, n3) == -1) {
                        this.doc.remove(i, n3);
                        this.doc.insertString(i, string2, null);
                        n5 = n5 - n3 + n4;
                        i += n4 - 1;
                        continue;
                    }
                    i = this.includeComponent(i, n3);
                }
                this.textPane.setSelectionStart(n);
                this.textPane.setSelectionEnd(n5 + n3 - 1);
            } else {
                if (n != n2) {
                    this.doc.remove(n, n2 - n);
                }
                this.doc.insertString(n, string2, null);
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.error("remplacer() - BadLocationException", badLocationException);
            return;
        }
    }

    public void toutRemplacer() {
        if (this.dansSelection) {
            this.remplacer();
            return;
        }
        texteRecherche = this.tfRechercher.getText();
        if (texteRecherche == null || texteRecherche.length() == 0) {
            return;
        }
        String string = this.tfRemplacer.getText();
        this.textPane.setSelectionStart(0);
        this.textPane.setSelectionEnd(0);
        if (this.textPane instanceof JaxeTextPane) {
            ((JaxeTextPane)this.textPane).debutEditionSpeciale(rb.getString("rechercher.Remplacer"), false);
        }
        int n = texteRecherche.length();
        int n2 = -1;
        int n3 = this.doc.getLength() - n;
        try {
            for (int i = 0; i < n3; ++i) {
                if (this.includeComponent(i, n) == -1) {
                    String string2 = this.doc.getText(i, n);
                    if ((this.ignorerCasse || !string2.equals(texteRecherche)) && (!this.ignorerCasse || !string2.equalsIgnoreCase(texteRecherche))) continue;
                    n2 = i;
                    this.doc.remove(i, n);
                    this.doc.insertString(i, string, null);
                    n3 = this.doc.getLength() - n;
                    continue;
                }
                i = this.includeComponent(i, n);
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.error("toutRemplacer() - BadLocationException", badLocationException);
            if (this.textPane instanceof JaxeTextPane) {
                ((JaxeTextPane)this.textPane).finEditionSpeciale();
            }
            return;
        }
        if (n2 == -1) {
            this.getToolkit().beep();
        }
        if (this.textPane instanceof JaxeTextPane) {
            ((JaxeTextPane)this.textPane).finEditionSpeciale();
        }
    }

    public void remplRech() {
        this.remplacer();
        this.suivant();
    }

    public String getTexteRecherche() {
        return this.tfRechercher.getText();
    }

    private int includeComponent(int n, int n2) {
        int n3 = -1;
        for (int i = n; i < n2 + n; ++i) {
            Element element = null;
            Component component = null;
            Icon icon = null;
            element = this.doc.getCharacterElement(i);
            component = StyleConstants.getComponent(element.getAttributes());
            icon = StyleConstants.getIcon(element.getAttributes());
            if (component == null && icon == null) continue;
            n3 = i;
        }
        return n3;
    }
}

