/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jaxe.DialogueRechercher;
import jaxe.JaxeDocument;
import jaxe.JaxeResourceBundle;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogueXpath
extends JFrame
implements ActionListener,
ItemListener,
CaretListener {
    private static final Logger LOG = Logger.getLogger(DialogueXpath.class);
    private static final ResourceBundle rb = JaxeResourceBundle.getRB();
    JTextField textF = new JTextField("");
    JCheckBox box1;
    JCheckBox box2;
    ButtonGroup groupe;
    private JButton butOk;
    private JButton butAnnuler;
    private ArrayList<Element> listeElements = new ArrayList();
    DialogueRechercher DialRech;
    JaxeDocument doc;
    private final JComboBox list;
    private Element refElementCourant;
    private String nomElementCourant = "";
    private JTextField textInterne;
    private ZoneAttribut[] attributs;
    String typeRechTxt;
    private final JPanel pane;
    private JPanel exprPane;
    private final JPanel listPane;
    private JPanel textPane;
    private JPanel attrPane;
    private JPanel buttonPane;
    private int natt;
    private boolean existNS = false;

    public DialogueXpath(DialogueRechercher dialogueRechercher, JaxeDocument jaxeDocument) {
        super(rb.getString("xpath.ExprXpath"));
        Object object;
        this.DialRech = dialogueRechercher;
        this.doc = jaxeDocument;
        Element element = jaxeDocument.DOMdoc.getDocumentElement();
        if (element != null && element.getNamespaceURI() != null) {
            this.existNS = true;
        }
        this.pane = new JPanel();
        this.pane.setLayout(new BoxLayout(this.pane, 1));
        this.listPane = new JPanel(new FlowLayout());
        JLabel jLabel = new JLabel(rb.getString("xpath.TitreElt"));
        this.listeElements = this.triListingElt(jaxeDocument.cfg.listeTousElements());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Element element2 : this.listeElements) {
            if (this.existNS) {
                String string = jaxeDocument.cfg.prefixeElement(element2);
                if (string == null) {
                    arrayList.add(jaxeDocument.cfg.titreElement(element2));
                    continue;
                }
                arrayList.add(string + ":" + jaxeDocument.cfg.titreElement(element2));
                continue;
            }
            arrayList.add(jaxeDocument.cfg.titreElement(element2));
        }
        this.list = new JComboBox<Object>(arrayList.toArray());
        if ("".equals(this.nomElementCourant)) {
            this.refElementCourant = this.listeElements.get(0);
            this.nomElementCourant = jaxeDocument.cfg.nomElement(this.refElementCourant);
            object = jaxeDocument.cfg.listeAttributs(this.refElementCourant);
            this.natt = ((ArrayList)object).size();
        }
        this.list.addItemListener(this);
        this.listPane.add(jLabel);
        this.listPane.add(this.list);
        this.majAttPanel();
        this.majExprXpath();
        this.setContentPane(this.pane);
        this.pack();
        object = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((((Dimension)object).width - this.getSize().width) / 2, (((Dimension)object).height - this.getSize().height) / 2);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DialogueXpath.this.dispose();
                DialogueXpath.this.DialRech.setVisible(true);
            }
        });
    }

    public void majAttPanel() {
        if (this.refElementCourant == null) {
            this.dispose();
            JOptionPane.showMessageDialog(this, rb.getString("xpath.ErrBalise"), rb.getString("xpath.Err"), 1);
            return;
        }
        this.textPane = new JPanel();
        this.textPane.setLayout(new BoxLayout(this.textPane, 0));
        JLabel jLabel = new JLabel(rb.getString("xpath.IncludingText"));
        this.textInterne = new JTextField("");
        this.textInterne.addCaretListener(this);
        this.typeRechTxt = "contient";
        this.groupe = new ButtonGroup();
        this.box1 = new JCheckBox(rb.getString("xpath.TexteExact"), false);
        this.groupe.add(this.box1);
        this.box1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                DialogueXpath.this.typeRechTxt = "texte exact";
                DialogueXpath.this.majExprXpath();
            }
        });
        this.box2 = new JCheckBox(rb.getString("xpath.Contient"), true);
        this.groupe.add(this.box2);
        this.box2.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                DialogueXpath.this.typeRechTxt = "contient";
                DialogueXpath.this.majExprXpath();
            }
        });
        this.textPane.add(Box.createHorizontalStrut(5));
        this.textPane.add(jLabel);
        this.textPane.add(Box.createHorizontalStrut(2));
        this.textPane.add(this.textInterne);
        this.textPane.add(this.box1);
        this.textPane.add(this.box2);
        this.textPane.add(Box.createHorizontalStrut(5));
        this.attrPane = new JPanel();
        JScrollPane jScrollPane = new JScrollPane(this.attrPane, 22, 31){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (dimension.height > 500) {
                    dimension.height = 500;
                }
                return dimension;
            }
        };
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        jScrollPane.setOpaque(false);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1, Color.white, new Color(70, 70, 70)), rb.getString("xpath.TitleAtt") + " \" " + this.doc.cfg.nomElement(this.refElementCourant) + " \"", 1, 2));
        ArrayList<Element> arrayList = this.doc.cfg.listeAttributs(this.refElementCourant);
        this.natt = arrayList.size();
        this.attributs = new ZoneAttribut[this.natt];
        this.attrPane.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (this.natt == 0) {
            JLabel jLabel2 = new JLabel(rb.getString("xpath.NoneAtt"));
            jLabel2.setForeground(Color.gray);
            this.attrPane.add(jLabel2);
            this.attrPane.add(Box.createVerticalStrut(30));
        }
        for (int i = 0; i < this.natt; ++i) {
            ZoneAttribut zoneAttribut;
            this.attributs[i] = zoneAttribut = new ZoneAttribut();
            Element element = arrayList.get(i);
            zoneAttribut.nom = this.doc.cfg.nomAttribut(element);
            zoneAttribut.titre = this.doc.cfg.titreAttribut(this.refElementCourant, element);
            JLabel jLabel3 = new JLabel(zoneAttribut.titre + " : ");
            ArrayList<String> arrayList2 = this.doc.cfg.listeValeursAttribut(element);
            zoneAttribut.valeurs = arrayList2;
            if (arrayList2 != null && arrayList2.size() > 0) {
                zoneAttribut.valeurs.add(0, "");
                String[] stringArray = new String[zoneAttribut.valeurs.size()];
                for (int j = 0; j < zoneAttribut.valeurs.size(); ++j) {
                    stringArray[j] = this.doc.cfg.titreValeurAttribut(this.refElementCourant, element, zoneAttribut.valeurs.get(j));
                }
                zoneAttribut.champ = new JComboBox<String>(stringArray);
                ((JComboBox)zoneAttribut.champ).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        DialogueXpath.this.majExprXpath();
                    }
                });
            } else {
                zoneAttribut.champ = new JTextField(42);
                ((JTextField)zoneAttribut.champ).addCaretListener(this);
            }
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i;
            gridBagConstraints.anchor = 13;
            this.attrPane.add((Component)jLabel3, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = i;
            gridBagConstraints.anchor = 17;
            this.attrPane.add((Component)zoneAttribut.champ, gridBagConstraints);
            if (zoneAttribut.champ instanceof JTextField) {
                zoneAttribut.typeRech = "contient";
                this.groupe = new ButtonGroup();
                this.box1 = new JCheckBox(rb.getString("xpath.MotExact"), false);
                this.groupe.add(this.box1);
                this.box1.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent itemEvent) {
                        zoneAttribut.typeRech = "mot exact";
                        DialogueXpath.this.majExprXpath();
                    }
                });
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = i;
                this.attrPane.add((Component)this.box1, gridBagConstraints);
                this.box2 = new JCheckBox(rb.getString("xpath.Contient"), true);
                this.groupe.add(this.box2);
                this.box2.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent itemEvent) {
                        zoneAttribut.typeRech = "contient";
                        DialogueXpath.this.majExprXpath();
                    }
                });
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = i;
                this.attrPane.add((Component)this.box2, gridBagConstraints);
                continue;
            }
            zoneAttribut.typeRech = "mot exact";
        }
        this.exprPane = new JPanel(new FlowLayout());
        JLabel jLabel4 = new JLabel(rb.getString("xpath.Expr"));
        this.textF = new JTextField("", 55);
        this.textF.setEditable(false);
        this.textF.setForeground(Color.red);
        this.exprPane.add(jLabel4);
        this.exprPane.add(this.textF);
        this.buttonPane = new JPanel();
        this.butOk = new JButton(rb.getString("xpath.Ok"));
        this.butOk.addActionListener(this);
        this.butOk.setActionCommand("OK");
        this.getRootPane().setDefaultButton(this.butOk);
        this.butAnnuler = new JButton(rb.getString("xpath.Annuler"));
        this.butAnnuler.addActionListener(this);
        this.butAnnuler.setActionCommand("Annuler");
        this.buttonPane.add(this.butOk);
        this.buttonPane.add(this.butAnnuler);
        this.pane.add(Box.createVerticalStrut(10));
        this.pane.add(this.listPane);
        this.pane.add(Box.createVerticalStrut(10));
        this.pane.add(this.textPane);
        this.pane.add(Box.createVerticalStrut(10));
        this.pane.add(jScrollPane);
        this.pane.add(Box.createVerticalStrut(10));
        this.pane.add(this.exprPane);
        this.pane.add(Box.createVerticalStrut(5));
        this.pane.add(this.buttonPane);
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.majExprXpath();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.butOk) {
            this.dispose();
            this.DialRech.tfRechercher.setText(this.textF.getText());
            this.DialRech.setVisible(true);
        }
        if (actionEvent.getSource() == this.butAnnuler) {
            this.dispose();
            this.DialRech.setVisible(true);
        }
    }

    public void majExprXpath() {
        String string;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.existNS) {
            string = this.doc.cfg.prefixeElement(this.refElementCourant);
            if (string != null) {
                stringBuilder.append("//");
                stringBuilder.append(string);
                stringBuilder.append(":");
                stringBuilder.append(this.nomElementCourant);
            } else {
                stringBuilder.append("//*[local-name()=\"");
                stringBuilder.append(this.nomElementCourant);
                stringBuilder.append("\"");
                bl = true;
            }
        } else {
            stringBuilder.append("//");
            stringBuilder.append(this.nomElementCourant);
        }
        string = this.textInterne.getText();
        if (!string.equals("")) {
            if (bl) {
                stringBuilder.append(" and ");
            } else {
                stringBuilder.append("[");
                bl = true;
            }
            if (this.typeRechTxt.equals("contient")) {
                stringBuilder.append("contains(.,\"");
                stringBuilder.append(string);
                stringBuilder.append("\")");
            } else {
                stringBuilder.append(".=\"");
                stringBuilder.append(string);
                stringBuilder.append("\"");
            }
        }
        for (ZoneAttribut zoneAttribut : this.attributs) {
            int n;
            String string2 = "";
            if (zoneAttribut.champ instanceof JTextField) {
                string2 = ((JTextField)zoneAttribut.champ).getText();
            } else if (zoneAttribut.champ instanceof JComboBox) {
                n = ((JComboBox)zoneAttribut.champ).getSelectedIndex();
                string2 = zoneAttribut.valeurs.get(n);
            }
            int n2 = n = !"".equals(string2) ? 1 : 0;
            if (n == 0) continue;
            if (bl) {
                stringBuilder.append(" and ");
            } else {
                stringBuilder.append("[");
                bl = true;
            }
            if (zoneAttribut.typeRech.equals("contient")) {
                stringBuilder.append("contains(@");
                stringBuilder.append(zoneAttribut.nom);
                stringBuilder.append(",\"");
                stringBuilder.append(string2);
                stringBuilder.append("\")");
                continue;
            }
            stringBuilder.append("@");
            stringBuilder.append(zoneAttribut.nom);
            stringBuilder.append("=\"");
            stringBuilder.append(string2);
            stringBuilder.append("\"");
        }
        if (bl) {
            stringBuilder.append("]");
        }
        this.textF.setText(stringBuilder.toString());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.list && itemEvent.getStateChange() == 1) {
            this.refElementCourant = this.listeElements.get(this.list.getSelectedIndex());
            this.nomElementCourant = this.doc.cfg.nomElement(this.refElementCourant);
            this.pane.removeAll();
            this.majAttPanel();
            this.pane.validate();
            this.majExprXpath();
            this.pack();
        }
    }

    public ArrayList<Element> triListingElt(ArrayList<Element> arrayList) {
        ArrayList<Element> arrayList2 = new ArrayList<Element>(arrayList.size());
        char[][] cArrayArray = new char[][]{{'\u00d4', 'O'}, {'\u00cf', 'I'}, {'\u00ce', 'I'}, {'\u00c0', 'A'}, {'\u00c2', 'A'}, {'\u00cb', 'E'}, {'\u00ca', 'E'}, {'\u00c8', 'E'}, {'\u00c9', 'E'}};
        if (arrayList.size() > 0) {
            arrayList2.add(0, arrayList.get(0));
        }
        for (int i = 1; i < arrayList.size(); ++i) {
            boolean bl = false;
            Object object = this.doc.cfg.titreElement(arrayList.get(i)).toUpperCase();
            for (char[] cArray : cArrayArray) {
                object = ((String)object).replace(cArray[0], cArray[1]);
            }
            for (int j = 0; j < i; ++j) {
                String string = this.doc.cfg.titreElement((Element)arrayList2.get(j)).toUpperCase();
                for (char[] cArray : cArrayArray) {
                    string = string.replace(cArray[0], cArray[1]);
                }
                if (((String)object).trim().compareToIgnoreCase(string.trim().toUpperCase()) > 0) continue;
                arrayList2.add(j, arrayList.get(i));
                bl = true;
                j = i;
            }
            if (bl) continue;
            arrayList2.add(i, arrayList.get(i));
        }
        ArrayList<Element> arrayList3 = new ArrayList<Element>();
        Element element = null;
        for (Element element2 : arrayList2) {
            if (element == null || !this.doc.cfg.nomElement(element).equals(this.doc.cfg.nomElement(element2))) {
                arrayList3.add(element2);
            } else {
                String string = this.doc.cfg.espaceElement(element);
                String string2 = this.doc.cfg.espaceElement(element2);
                if (!(string2 == null && string == null || string2 != null && string2.equals(string))) {
                    arrayList3.add(element2);
                }
            }
            element = element2;
        }
        return arrayList3;
    }

    class ZoneAttribut {
        JComponent champ;
        String nom;
        String titre;
        ArrayList<String> valeurs;
        String typeRech;

        ZoneAttribut() {
        }
    }
}

