/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLDocument;
import jaxe.Export;
import jaxe.JaxeDocument;
import jaxe.JaxeResourceBundle;
import jaxe.Preferences;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class HTMLFrame
extends JFrame {
    private static final Logger LOG = Logger.getLogger(HTMLFrame.class);
    JaxeDocument doc;
    HTMLDocument htmldoc;
    JTextPane textPane;
    JButton boutonNav;

    public HTMLFrame(JaxeDocument jaxeDocument) {
        this.newdoc(jaxeDocument);
    }

    public void newdoc(JaxeDocument jaxeDocument) {
        this.doc = jaxeDocument;
        if (jaxeDocument.cfg == null) {
            return;
        }
        this.htmldoc = new HTMLDocument();
        Rectangle rectangle = jaxeDocument.jframe.getBounds();
        this.setLocation(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        this.setSize(new Dimension(620, 460));
        this.affichage();
        if (jaxeDocument.fsave != null) {
            File file = HTMLFrame.fichierHTML(jaxeDocument.fsave);
            if (file.exists()) {
                try {
                    URL uRL = file.toURI().toURL();
                    this.textPane.setPage(uRL);
                    this.setTitle(file.getName());
                }
                catch (Exception exception) {
                    this.afficherErreur(exception);
                }
                this.setVisible(true);
            } else {
                this.miseAJour();
            }
        } else {
            JOptionPane.showMessageDialog(jaxeDocument.jframe, JaxeResourceBundle.getRB().getString("html.SauverAvant"), JaxeResourceBundle.getRB().getString("erreur.Erreur"), 0);
        }
    }

    protected void affichage() {
        this.textPane = new JTextPane(this.htmldoc);
        this.textPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.textPane);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(600, 400));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JButton jButton = new JButton(JaxeResourceBundle.getRB().getString("html.MiseAJour"));
        jButton.addActionListener(new MAJListener());
        jPanel.add(jButton);
        this.boutonNav = new JButton();
        this.boutonNav.setAction(new AbstractAction(JaxeResourceBundle.getRB().getString("html.Navigateur")){

            public void actionPerformed(ActionEvent actionEvent) {
                HTMLFrame.this.lancerNavigateur();
            }
        });
        jPanel.add(this.boutonNav);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)jPanel, "North");
        this.setContentPane(jPanel2);
    }

    public static File fichierHTML(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n != -1 && !"html".equals(string.substring(n + 1))) {
            string = string.substring(0, n);
        }
        return new File(file.getParent() + File.separatorChar + string + ".html");
    }

    public void miseAJour() {
        if (this.doc.fsave == null) {
            JOptionPane.showMessageDialog(this.doc.jframe, JaxeResourceBundle.getRB().getString("html.SauverAvant"), JaxeResourceBundle.getRB().getString("erreur.Erreur"), 0);
            return;
        }
        ArrayList<Element> arrayList = this.doc.cfg.listeExports("HTML");
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        Export export = new Export(this.doc, arrayList.get(0));
        export.transformation(HTMLFrame.fichierHTML(this.doc.fsave), this);
    }

    public void afficherHTML(File file) {
        try {
            this.affichage();
            if (file != null) {
                URL uRL = file.toURI().toURL();
                this.textPane.setPage(uRL);
                this.setTitle(file.getName());
            }
        }
        catch (Exception exception) {
            this.afficherErreur(exception);
        }
        this.setVisible(true);
    }

    protected void afficherErreur(Exception exception) {
        JOptionPane.showMessageDialog(this.doc.jframe, exception.getClass().getName() + ": " + exception.getMessage(), JaxeResourceBundle.getRB().getString("erreur.Erreur"), 0);
    }

    public void lancerNavigateur() {
        Properties properties = Preferences.getPref();
        String string = properties.getProperty("navigateur");
        if (string == null) {
            this.defNavigateur();
            properties = Preferences.getPref();
            string = properties.getProperty("navigateur");
            if (string == null) {
                return;
            }
        }
        File file = HTMLFrame.fichierHTML(this.doc.fsave);
        String[] stringArray = System.getProperty("os.name").startsWith("Mac") ? new String[]{"/usr/bin/open", "-a", string, file.getAbsolutePath()} : new String[]{string, file.getAbsolutePath()};
        try {
            Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            LOG.error("lancerNavigateur()", iOException);
        }
    }

    public void defNavigateur() {
        FileDialog fileDialog = new FileDialog((Frame)this, JaxeResourceBundle.getRB().getString("html.DefNavigateur"), 0);
        fileDialog.setVisible(true);
        String string = null;
        String string2 = fileDialog.getDirectory();
        if (string2 != null && string2.endsWith(File.separator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        String string3 = fileDialog.getFile();
        if (string2 == null) {
            string = string3;
        } else if (string3 != null) {
            string = string2 + File.separator + string3;
        }
        if (string != null) {
            Properties properties = Preferences.getPref();
            properties.setProperty("navigateur", string);
            Preferences.enregistrerPref(properties);
        }
    }

    class MAJListener
    implements ActionListener {
        MAJListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLFrame.this.miseAJour();
        }
    }
}

