/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.swing.text.TextAction;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import jaxe.ActionInsertionBalise;
import jaxe.Config;
import jaxe.DialogueAideElement;
import jaxe.DialogueRechercher;
import jaxe.EcouteurMAJ;
import jaxe.JaxeDocument;
import jaxe.JaxeElement;
import jaxe.JaxeResourceBundle;
import jaxe.JaxeTransferHandler;
import jaxe.JaxeUndoManager;
import jaxe.elements.JEStyle;
import jaxe.elements.JESwing;
import jaxe.elements.JETexte;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JaxeTextPane
extends JTextPane {
    private static final Logger LOG = Logger.getLogger(JaxeTextPane.class);
    static int cmdMenu;
    UndoManager undo;
    boolean ignorerEdition = false;
    private boolean editionSpeciale = false;
    private CompoundEdit editSpecial;
    private int niveauEditionSpeciale = 0;
    private final Stack<Boolean> ignorerEditionStack = new Stack();
    static String texteRecherche;
    private final ArrayList<EcouteurMAJ> ecouteursArbre = new ArrayList();
    private final ArrayList<EcouteurMAJ> ecouteursAnnulation = new ArrayList();
    private DialogueRechercher dlgRecherche = null;
    JaxeDocument doc;
    public JFrame jframe;
    public boolean iconeValide = true;
    private static final JaxeTransferHandler jth;

    public JaxeTextPane(JaxeDocument jaxeDocument, JFrame jFrame) {
        this(jaxeDocument, jFrame, true);
    }

    public JaxeTextPane(JaxeDocument jaxeDocument, JFrame jFrame, boolean bl) {
        this.setEditorKit(jaxeDocument.createEditorKit());
        this.setStyledDocument(jaxeDocument);
        this.undo = new JaxeUndoManager(jaxeDocument);
        this.doc = jaxeDocument;
        this.iconeValide = bl;
        this.jframe = jFrame;
        jaxeDocument.setTextPane(this);
        cmdMenu = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        Keymap keymap = this.getKeymap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(68, cmdMenu);
        keymap.addActionForKeyStroke(keyStroke, new ActionMenuContextuel());
        jaxeDocument.addUndoableEditListener(new MyUndoableEditListener());
        this.addCaretListener(new MyCaretListener());
        this.setTabs(4);
        this.setHighlighter(new JaxeHighlighter());
        this.setTransferHandler(jth);
        this.setDragEnabled(true);
    }

    public UndoManager getUndo() {
        return this.undo;
    }

    public void undo() {
        try {
            this.undo.undo();
        }
        catch (CannotUndoException cannotUndoException) {
            LOG.error("undo() - " + JaxeResourceBundle.getRB().getString("annulation.ImpossibleAnnuler"), cannotUndoException);
        }
        this.miseAJourAnnulation();
    }

    public boolean getEditionSpeciale() {
        return this.editionSpeciale;
    }

    public boolean getIgnorerEdition() {
        return this.ignorerEdition;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && this.isEditable()) {
            this.showPopup(mouseEvent);
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }

    private void showPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.menuContextuel(-1, mouseEvent.getPoint());
        }
    }

    protected void menuContextuel(int n, Point point) {
        Config config;
        JaxeElement jaxeElement;
        Serializable serializable;
        int n2 = this.getSelectionStart();
        int n3 = this.getSelectionEnd();
        int n4 = n == -1 && this.doc.rootJE != null && point != null ? this.viewToModel(point) : -1;
        if (n4 != -1 && (n2 == n3 || n4 < n2 || n4 > n3)) {
            n2 = n4;
            n3 = n4;
            this.setCaretPosition(n2);
            this.moveCaretPosition(n3);
        } else if (n != -1 && n2 == n3) {
            n2 = n;
            n3 = n;
            this.setCaretPosition(n2);
            this.moveCaretPosition(n3);
        }
        if (point == null) {
            try {
                serializable = this.modelToView(n2);
                point = ((Rectangle)serializable).getLocation();
            }
            catch (BadLocationException badLocationException) {
                LOG.error("menuContextuel(Point)", badLocationException);
                return;
            }
        }
        serializable = new JPopupMenu();
        ArrayList<Element> arrayList = null;
        if (this.doc.rootJE == null) {
            jaxeElement = null;
            config = this.doc.cfg;
            arrayList = config.listeElementsRacines();
        } else {
            jaxeElement = this.doc.elementA(n2);
            if (jaxeElement == null) {
                return;
            }
            if (jaxeElement instanceof JETexte) {
                jaxeElement = jaxeElement.getParent();
            }
            if (n2 == jaxeElement.debut.getOffset() && !(jaxeElement instanceof JESwing)) {
                jaxeElement = jaxeElement.getParent();
            }
            if (jaxeElement == null || !jaxeElement.getEditionAutorisee()) {
                return;
            }
            if (this.doc.cfg == null || !(jaxeElement.noeud instanceof Element)) {
                config = null;
                arrayList = new ArrayList();
            } else {
                config = this.doc.cfg.getElementConf((Element)jaxeElement.noeud);
                arrayList = config.listeSousElements(jaxeElement.refElement);
            }
        }
        for (Element element : arrayList) {
            if ("style".equals(this.doc.cfg.typeAffichageElement(element)) || jaxeElement != null && !config.insertionPossible(jaxeElement, n2, n3, element)) continue;
            String string = config.nomElement(element);
            String string2 = config.titreMenu(string);
            ((JPopupMenu)serializable).add(new ActionInsertionBalise(this.doc, string2, element, string, "element"));
        }
        if (arrayList.size() > 0) {
            ((JPopupMenu)serializable).addSeparator();
        }
        if (n2 != n3) {
            ((JPopupMenu)serializable).add(new ActionCouper());
            ((JPopupMenu)serializable).add(new ActionCopier());
        }
        ((JPopupMenu)serializable).add(new ActionColler());
        if (jaxeElement != null && config != null) {
            ((JPopupMenu)serializable).addSeparator();
            ((JPopupMenu)serializable).add(new ActionAide(jaxeElement.refElement));
        }
        ((JPopupMenu)serializable).show(this, point.x, point.y);
    }

    public void selectZone(int n, int n2, boolean bl, boolean bl2) {
        ArrayList<JaxeElement> arrayList = this.doc.rootJE.elementsDans(n, n2 - 1);
        if (bl) {
            boolean bl3;
            JaxeElement jaxeElement;
            int n3 = n;
            int n4 = n2;
            JaxeElement jaxeElement2 = this.doc.elementA(n);
            if (jaxeElement2 instanceof JETexte || jaxeElement2 instanceof JEStyle) {
                jaxeElement2 = jaxeElement2.getParent();
            }
            if ((jaxeElement = this.doc.elementA(n2)) instanceof JETexte || jaxeElement instanceof JEStyle) {
                jaxeElement = jaxeElement.getParent();
            }
            do {
                bl3 = false;
                if (jaxeElement2 != null && jaxeElement2.debut.getOffset() < n3 && n4 > jaxeElement2.fin.getOffset() && !arrayList.contains(jaxeElement2)) {
                    n3 = jaxeElement2.fin.getOffset() + 1;
                    bl3 = true;
                    jaxeElement2 = this.doc.elementA(n3);
                    if (jaxeElement2 instanceof JETexte || jaxeElement2 instanceof JEStyle) {
                        jaxeElement2 = jaxeElement2.getParent();
                    }
                }
                if (jaxeElement == null || jaxeElement.debut.getOffset() >= n4 || (!(jaxeElement instanceof JESwing) || n3 >= jaxeElement.debut.getOffset()) && (jaxeElement instanceof JESwing || n3 > jaxeElement.debut.getOffset()) || arrayList.contains(jaxeElement)) continue;
                n4 = jaxeElement.debut.getOffset();
                bl3 = true;
                jaxeElement = this.doc.elementA(n4);
                if (!(jaxeElement instanceof JETexte) && !(jaxeElement instanceof JEStyle)) continue;
                jaxeElement = jaxeElement.getParent();
            } while (bl3);
            for (JaxeElement jaxeElement3 : arrayList) {
                JaxeElement jaxeElement4;
                Object object;
                Node node;
                if (jaxeElement3.debut.getOffset() < n3 || jaxeElement3.fin.getOffset() >= n4) continue;
                JaxeElement jaxeElement5 = jaxeElement3.getParent();
                if (!(jaxeElement5 == null || jaxeElement5 instanceof JETexte || jaxeElement5 instanceof JEStyle || arrayList.contains(jaxeElement5))) {
                    if (n3 <= jaxeElement5.debut.getOffset()) {
                        n3 = jaxeElement5 instanceof JESwing ? jaxeElement5.debut.getOffset() : jaxeElement5.debut.getOffset() + 1;
                    }
                    if (n4 > jaxeElement5.fin.getOffset()) {
                        n4 = jaxeElement5.fin.getOffset();
                    }
                }
                if (!((node = jaxeElement3.noeud.getPreviousSibling()) == null || (object = this.doc.getElementForNode(node)) == null || ((JaxeElement)object).fin == null || object instanceof JETexte || object instanceof JEStyle || arrayList.contains(object) || n3 > ((JaxeElement)object).fin.getOffset())) {
                    n3 = object instanceof JESwing ? ((JaxeElement)object).fin.getOffset() : ((JaxeElement)object).fin.getOffset() + 1;
                }
                if ((object = jaxeElement3.noeud.getNextSibling()) == null || (jaxeElement4 = this.doc.getElementForNode((Node)object)) == null || jaxeElement4.debut == null || jaxeElement4 instanceof JETexte || jaxeElement4 instanceof JEStyle || arrayList.contains(jaxeElement4) || n4 <= jaxeElement4.debut.getOffset()) continue;
                n4 = jaxeElement4.debut.getOffset();
            }
            if (bl2 && (n3 != n || n4 != n2)) {
                if (n4 == n3) {
                    n4 = n3 = n;
                }
                SwingUtilities.invokeLater(new ChangementSelection(n3, n4));
            }
            if (n3 != n || n4 != n2) {
                arrayList = this.doc.rootJE.elementsDans(n3, n4 - 1);
            }
        }
        for (JaxeElement jaxeElement : arrayList) {
            jaxeElement.selection(bl);
        }
    }

    public void selectElement(Node node) {
        JaxeElement jaxeElement = this.doc.getElementForNode(node);
        if (jaxeElement == null && node.getParentNode() != null) {
            jaxeElement = this.doc.getElementForNode(node.getParentNode());
        }
        if (jaxeElement == null) {
            return;
        }
        this.select(jaxeElement.debut.getOffset(), jaxeElement.fin.getOffset() + 1);
    }

    public void allerLigne(int n) {
        n = n > 0 ? --n : 0;
        int n2 = this.doc.getDefaultRootElement().getElement(n).getStartOffset();
        try {
            this.scrollRectToVisible(this.modelToView(this.doc.getLength()));
            this.scrollRectToVisible(this.modelToView(n2));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void allerElement(Element element) {
        Point point;
        JaxeElement jaxeElement = this.doc.getElementForNode(element);
        if (jaxeElement != null) {
            int n = jaxeElement.debut.getOffset();
            try {
                Rectangle rectangle = this.doc.textPane.modelToView(n);
                point = new Point(rectangle.x, rectangle.y);
            }
            catch (BadLocationException badLocationException) {
                LOG.error("JaxeTextPane.allerElement modelToView", badLocationException);
                return;
            }
        } else {
            Node node;
            jaxeElement = this.doc.getElementForNode(node);
            for (node = element.getParentNode(); jaxeElement == null && node != null && node.getNodeType() == 1; node = node.getParentNode()) {
                jaxeElement = this.doc.getElementForNode(node);
            }
            point = jaxeElement != null ? jaxeElement.getPointEnfant(element) : null;
            if (point == null) {
                return;
            }
        }
        Rectangle rectangle = new Rectangle(point);
        rectangle.height = this.doc.textPane.getVisibleRect().height - 1;
        this.doc.textPane.scrollRectToVisible(rectangle);
    }

    public void debutIgnorerEdition() {
        this.ignorerEdition = true;
    }

    public void finIgnorerEdition() {
        this.ignorerEdition = false;
    }

    public void debutEditionSpeciale(String string, boolean bl) {
        if (this.niveauEditionSpeciale < 0) {
            LOG.error("debutEditionSpeciale(String, boolean) - Erreur: niveauEditionSpeciale < 0 !", null);
        }
        if (this.niveauEditionSpeciale == 0) {
            this.editSpecial = new EditSpecial(string);
            this.editionSpeciale = true;
            this.ignorerEdition = bl;
        } else {
            this.ignorerEditionStack.push(bl);
            this.ignorerEdition = bl;
        }
        ++this.niveauEditionSpeciale;
    }

    public void finEditionSpeciale() {
        --this.niveauEditionSpeciale;
        if (this.niveauEditionSpeciale < 0) {
            LOG.error("finEditionSpeciale() - Erreur: niveauEditionSpeciale < 0 !", null);
        }
        if (this.niveauEditionSpeciale == 0) {
            this.editSpecial.end();
            this.undo.addEdit(this.editSpecial);
            this.miseAJourAnnulation();
            this.editionSpeciale = false;
            this.ignorerEdition = false;
            this.editSpecial = null;
        } else {
            this.ignorerEdition = this.ignorerEditionStack.pop();
        }
    }

    public void addEdit(UndoableEdit undoableEdit) {
        if (this.editionSpeciale) {
            this.editSpecial.addEdit(undoableEdit);
        } else {
            this.getUndo().addEdit(undoableEdit);
            this.miseAJourAnnulation();
        }
        this.doc.setModif(true);
    }

    @Deprecated
    public void couper() {
        this.cut();
    }

    @Deprecated
    public void couper(int n, int n2) {
        this.cut();
    }

    @Deprecated
    public void copier() {
        this.copy();
    }

    @Deprecated
    public boolean coller() {
        this.paste();
        return true;
    }

    @Deprecated
    public static void effacerPressePapier() {
    }

    public void toutSelectionner() {
        this.setCaretPosition(0);
        this.moveCaretPosition(this.doc.getLength());
    }

    public void rechercher() {
        if (this.dlgRecherche == null) {
            this.dlgRecherche = new DialogueRechercher(this.doc, this);
        }
        this.dlgRecherche.setVisible(true);
    }

    public void rechercher(String string) {
        texteRecherche = string;
        int n = texteRecherche.length();
        int n2 = -1;
        try {
            for (int i = 0; i < this.doc.getLength() - n; ++i) {
                String string2 = this.doc.getText(i, n);
                if (!string2.equals(texteRecherche)) continue;
                n2 = i;
                break;
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.error("rechercher(String) - BadLocationException", badLocationException);
            return;
        }
        if (n2 != -1) {
            this.setCaretPosition(n2);
            this.moveCaretPosition(n2 + n);
        } else {
            this.getToolkit().beep();
        }
    }

    public void suivant() {
        if (this.dlgRecherche != null) {
            texteRecherche = this.dlgRecherche.getTexteRecherche();
            if (this.dlgRecherche.RechXpath) {
                this.dlgRecherche.suivantXpath(this.getSelectionStart());
            } else {
                this.dlgRecherche.suivant(this.getSelectionStart());
            }
        }
    }

    public void ajouterEcouteurArbre(EcouteurMAJ ecouteurMAJ) {
        this.ecouteursArbre.add(ecouteurMAJ);
    }

    public void retirerEcouteurArbre(EcouteurMAJ ecouteurMAJ) {
        this.ecouteursArbre.remove(ecouteurMAJ);
    }

    public void miseAJourArbre() {
        for (EcouteurMAJ ecouteurMAJ : this.ecouteursArbre) {
            ecouteurMAJ.miseAJour();
        }
    }

    public void ajouterEcouteurAnnulation(EcouteurMAJ ecouteurMAJ) {
        this.ecouteursAnnulation.add(ecouteurMAJ);
    }

    public void retirerEcouteurAnnulation(EcouteurMAJ ecouteurMAJ) {
        this.ecouteursAnnulation.remove(ecouteurMAJ);
    }

    public void miseAJourAnnulation() {
        for (EcouteurMAJ ecouteurMAJ : this.ecouteursAnnulation) {
            ecouteurMAJ.miseAJour();
        }
    }

    public void setTabs(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n2 = fontMetrics.charWidth('w');
        int n3 = n2 * n;
        TabStop[] tabStopArray = new TabStop[10];
        for (int i = 0; i < tabStopArray.length; ++i) {
            int n4 = i + 1;
            tabStopArray[i] = new TabStop(n4 * n3);
        }
        TabSet tabSet = new TabSet(tabStopArray);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setTabSet(simpleAttributeSet, tabSet);
        int n5 = this.doc.getLength();
        this.debutIgnorerEdition();
        this.doc.setParagraphAttributes(0, n5, simpleAttributeSet, false);
        this.finIgnorerEdition();
    }

    public void setIconeValide(boolean bl) {
        this.iconeValide = bl;
        if (this.doc != null) {
            this.doc.styleChanged();
        }
        this.doLayout();
    }

    static {
        texteRecherche = null;
        jth = new JaxeTransferHandler();
    }

    protected class MyCaretListener
    implements CaretListener {
        boolean run = true;
        int vdot = 0;
        int vmark = 0;

        protected MyCaretListener() {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            if (this.run) {
                int n;
                this.run = false;
                int n2 = caretEvent.getDot();
                if (n2 == (n = caretEvent.getMark())) {
                    if (this.vmark - this.vdot > 0) {
                        JaxeTextPane.this.selectZone(this.vdot, this.vmark, false, true);
                    }
                } else {
                    if (n2 > n) {
                        n2 += n;
                        n = n2 - n;
                        n2 -= n;
                    }
                    if (this.vdot != n2 || this.vmark != n) {
                        JaxeTextPane.this.selectZone(this.vdot, this.vmark, false, true);
                    }
                    JaxeTextPane.this.selectZone(n2, n, true, true);
                }
                this.vdot = n2;
                this.vmark = n;
                this.run = true;
            }
        }
    }

    protected class MyUndoableEditListener
    implements UndoableEditListener {
        protected MyUndoableEditListener() {
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            if (!JaxeTextPane.this.ignorerEdition) {
                JaxeTextPane.this.undo.addEdit(undoableEditEvent.getEdit());
                JaxeTextPane.this.miseAJourAnnulation();
            }
        }
    }

    class EditSpecial
    extends CompoundEdit {
        String titre;

        public EditSpecial(String string) {
            this.titre = string;
        }

        public String getPresentationName() {
            return this.titre;
        }

        public String getUndoPresentationName() {
            return JaxeResourceBundle.getRB().getString("menus.Annuler") + " " + this.titre;
        }

        public String getRedoPresentationName() {
            return JaxeResourceBundle.getRB().getString("menus.Retablir") + " " + this.titre;
        }
    }

    class ChangementSelection
    implements Runnable {
        private int debut;
        private int fin;

        public ChangementSelection(int n, int n2) {
            this.debut = n;
            this.fin = n2;
        }

        public void run() {
            JaxeTextPane.this.setCaretPosition(this.debut);
            JaxeTextPane.this.moveCaretPosition(this.fin);
        }
    }

    class ActionAide
    extends AbstractAction {
        Element refElement;

        ActionAide(Element element) {
            super(JaxeResourceBundle.getRB().getString("aide.element") + " " + JaxeTextPane.this.doc.cfg.titreElement(element));
            this.refElement = element;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DialogueAideElement dialogueAideElement = new DialogueAideElement(this.refElement, JaxeTextPane.this.doc.cfg.getRefConf(this.refElement), (JFrame)JaxeTextPane.this.getTopLevelAncestor());
            dialogueAideElement.setVisible(true);
        }
    }

    protected static class ActionColler
    extends TextAction {
        public ActionColler() {
            super(JaxeResourceBundle.getRB().getString("menus.Coller"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.paste();
            }
        }
    }

    protected static class ActionCopier
    extends TextAction {
        public ActionCopier() {
            super(JaxeResourceBundle.getRB().getString("menus.Copier"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.copy();
            }
        }
    }

    protected static class ActionCouper
    extends TextAction {
        public ActionCouper() {
            super(JaxeResourceBundle.getRB().getString("menus.Couper"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.cut();
            }
        }
    }

    protected static class ActionMenuContextuel
    extends TextAction {
        public ActionMenuContextuel() {
            super("menuContextuel");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof JaxeTextPane) {
                ((JaxeTextPane)jTextComponent).menuContextuel(-1, null);
            }
        }
    }

    class JaxeHighlighter
    extends DefaultHighlighter {
        JaxeHighlighter() {
        }

        public Object addHighlight(int n, int n2, Highlighter.HighlightPainter highlightPainter) throws BadLocationException {
            Object object = super.addHighlight(n, n2, highlightPainter);
            JaxeTextPane.this.selectZone(n, n2, true, false);
            return object;
        }

        public void changeHighlight(Object object, int n, int n2) throws BadLocationException {
            Highlighter.Highlight highlight = (Highlighter.Highlight)object;
            int n3 = highlight.getStartOffset();
            int n4 = highlight.getEndOffset();
            super.changeHighlight(object, n, n2);
            JaxeTextPane.this.selectZone(n3, n4, false, false);
            JaxeTextPane.this.selectZone(n, n2, true, false);
        }

        public void removeHighlight(Object object) {
            super.removeHighlight(object);
            Highlighter.Highlight highlight = (Highlighter.Highlight)object;
            JaxeTextPane.this.selectZone(highlight.getStartOffset(), highlight.getEndOffset(), false, false);
        }
    }
}

