/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import jaxe.DialogueRechercher;
import jaxe.DocumentRenderer;
import jaxe.JaxeDocument;
import jaxe.JaxeFrame;
import jaxe.JaxeMenuBar;
import jaxe.JaxeResourceBundle;
import org.apache.log4j.Logger;

public class SourceFrame
extends JFrame
implements ActionListener {
    private static final Logger LOG = Logger.getLogger(SourceFrame.class);
    private JaxeDocument jdoc;
    private final JaxeFrame jframe;
    private StyledDocument srcdoc;
    JTextPane textPane;
    private Style styleElement;
    private Style styleNomAttribut;
    private Style styleValeurAttribut;
    private Style styleTexte;
    private Style styleEntite;
    private Style styleCommentaire;
    private DialogueRechercher dlgRecherche = null;
    static String texteRecherche = null;

    public SourceFrame(JaxeDocument jaxeDocument, JaxeFrame jaxeFrame) {
        this.jframe = jaxeFrame;
        this.newdoc(jaxeDocument);
    }

    public void newdoc(JaxeDocument jaxeDocument) {
        int n;
        this.jdoc = jaxeDocument;
        JaxeMenuBar jaxeMenuBar = new JaxeMenuBar(this, this.jframe);
        this.setJMenuBar(jaxeMenuBar);
        Rectangle rectangle = this.jframe.getBounds();
        this.setLocation(rectangle.x + rectangle.width / 3 + 50, rectangle.y + rectangle.height / 3 + 50);
        Dimension dimension = this.getToolkit().getScreenSize();
        int n2 = dimension.width / 2;
        if (n2 < 620) {
            n2 = dimension.width - 20;
        }
        if ((n = dimension.height * 2 / 3) < 460) {
            n = dimension.height - 50;
        }
        this.setSize(new Dimension(n2, n));
        this.affichage();
        this.miseAJour();
    }

    protected void affichage() {
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.textPane);
        jScrollPane.setVerticalScrollBarPolicy(22);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JButton jButton = new JButton(JaxeResourceBundle.getRB().getString("source.MiseAJour"));
        jButton.addActionListener(this);
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)jPanel, "North");
        this.setContentPane(jPanel2);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                SourceFrame.this.textPane.requestFocus();
            }
        });
    }

    public void miseAJour() {
        String[] stringArray;
        if (this.dlgRecherche != null) {
            if (this.dlgRecherche.isVisible()) {
                this.dlgRecherche.setVisible(false);
            }
            this.dlgRecherche = null;
        }
        try {
            stringArray = new BufferedReader(this.jdoc.getReader());
            this.textPane.read((Reader)stringArray, null);
        }
        catch (IOException iOException) {
            LOG.error("miseAJour()", iOException);
            return;
        }
        this.srcdoc = (StyledDocument)this.textPane.getDocument();
        this.setTabs(4);
        stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        boolean bl = false;
        for (String string : stringArray) {
            if (!"Monaco".equals(string)) continue;
            bl = true;
            break;
        }
        if (bl) {
            Style style = this.textPane.getStyle("default");
            StyleConstants.setFontFamily(style, "Monaco");
            StyleConstants.setFontSize(style, 12);
        }
        Style style = this.textPane.getStyle("default");
        this.styleElement = this.textPane.addStyle(null, style);
        StyleConstants.setForeground(this.styleElement, new Color(150, 0, 0));
        this.styleNomAttribut = this.textPane.addStyle(null, style);
        StyleConstants.setForeground(this.styleNomAttribut, new Color(0, 0, 150));
        this.styleValeurAttribut = this.textPane.addStyle(null, style);
        StyleConstants.setForeground(this.styleValeurAttribut, new Color(0, 100, 0));
        this.styleEntite = this.textPane.addStyle(null, style);
        StyleConstants.setForeground(this.styleEntite, new Color(0, 100, 100));
        this.styleCommentaire = this.textPane.addStyle(null, style);
        StyleConstants.setForeground(this.styleCommentaire, Color.gray);
        this.styleTexte = this.textPane.addStyle(null, style);
        StyleConstants.setForeground(this.styleTexte, Color.black);
        this.toutColorier();
        if (this.jdoc.fsave != null) {
            this.setTitle(this.jdoc.fsave.getName());
        } else {
            this.setTitle(JaxeResourceBundle.getRB().getString("menus.Source"));
        }
        this.setVisible(true);
    }

    public void colorier(int n, int n2) {
        int n3;
        Buffer buffer = new Buffer();
        if (buffer.subEquals("\n", n)) {
            if (n2 - n > 1) {
                this.srcdoc.setCharacterAttributes(n + 1, n2 - n - 1, this.styleTexte, false);
            }
        } else {
            this.srcdoc.setCharacterAttributes(n, n2 - n, this.styleTexte, false);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        char c = '\"';
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n4 = n;
        for (n3 = n; n3 < n2; ++n3) {
            char c2;
            if (bl6) {
                if (!buffer.subEquals("-->", n3)) continue;
                bl6 = false;
                this.srcdoc.setCharacterAttributes(n4, (n3 += 2) - n4 + 1, this.styleCommentaire, false);
                continue;
            }
            if (bl) {
                c2 = buffer.getChar(n3);
                if (c2 == ' ' || c2 == '\n') {
                    bl = false;
                    this.srcdoc.setCharacterAttributes(n4, n3 - n4, this.styleElement, false);
                    bl2 = true;
                    n4 = n3 + 1;
                    continue;
                }
                if (c2 != '>' && n3 != n2 - 1) continue;
                bl = false;
                this.srcdoc.setCharacterAttributes(n4, n3 - n4 + 1, this.styleElement, false);
                continue;
            }
            if (bl2) {
                c2 = buffer.getChar(n3);
                if (c2 == '>' || n3 == n2 - 1) {
                    bl2 = false;
                    this.srcdoc.setCharacterAttributes(n4, n3 - n4 + 1, this.styleElement, false);
                    continue;
                }
                if (c2 != '=') continue;
                bl2 = false;
                this.srcdoc.setCharacterAttributes(n4, n3 - n4, this.styleNomAttribut, false);
                bl3 = true;
                continue;
            }
            if (bl3) {
                c2 = buffer.getChar(n3);
                if (c2 != '\"' && c2 != '\'') continue;
                bl3 = false;
                bl4 = true;
                c = c2;
                n4 = n3;
                continue;
            }
            if (bl4) {
                c2 = buffer.getChar(n3);
                if (c2 != c && n3 != n2 - 1) continue;
                bl4 = false;
                this.srcdoc.setCharacterAttributes(n4, n3 - n4 + 1, this.styleValeurAttribut, false);
                bl2 = true;
                n4 = n3 + 1;
                continue;
            }
            if (bl5) {
                c2 = buffer.getChar(n3);
                if (c2 != ';' && c2 != ' ' && c2 != '\n' && n3 != n2 - 1) continue;
                bl5 = false;
                this.srcdoc.setCharacterAttributes(n4, n3 - n4 + 1, this.styleEntite, false);
                continue;
            }
            c2 = buffer.getChar(n3);
            if (c2 == '<') {
                if (buffer.subEquals("<!--", n3)) {
                    bl6 = true;
                } else {
                    bl = true;
                }
                n4 = n3;
                continue;
            }
            if (c2 == '>') {
                this.srcdoc.setCharacterAttributes(n3, 1, this.styleElement, false);
                continue;
            }
            if (c2 != '&' && c2 != '%') continue;
            bl5 = true;
            n4 = n3;
        }
        if (bl6) {
            for (n3 = n2; n3 < this.srcdoc.getLength() && bl6; ++n3) {
                if (!buffer.subEquals("-->", n3)) continue;
                bl6 = false;
                this.srcdoc.setCharacterAttributes(n4, (n3 += 2) - n4 + 1, this.styleCommentaire, false);
            }
            if (bl6) {
                this.srcdoc.setCharacterAttributes(n4, this.srcdoc.getLength() - n4, this.styleCommentaire, false);
            }
        }
    }

    public void toutColorier() {
        this.colorier(0, this.srcdoc.getLength());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.miseAJour();
    }

    public void allerLigne(int n) {
        n = n > 0 ? --n : 0;
        int n2 = this.srcdoc.getDefaultRootElement().getElement(n).getStartOffset();
        try {
            this.textPane.scrollRectToVisible(this.textPane.modelToView(this.srcdoc.getLength()));
            this.textPane.scrollRectToVisible(this.textPane.modelToView(n2));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void selectLigne(int n) {
        n = n > 0 ? --n : 0;
        Element element = this.srcdoc.getDefaultRootElement().getElement(n);
        try {
            this.textPane.scrollRectToVisible(this.textPane.modelToView(element.getStartOffset()));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.textPane.setCaretPosition(element.getStartOffset());
        if (element.getEndOffset() <= this.srcdoc.getLength()) {
            this.textPane.moveCaretPosition(element.getEndOffset());
        } else {
            this.textPane.moveCaretPosition(this.srcdoc.getLength());
        }
    }

    public void setTabs(int n) {
        FontMetrics fontMetrics = this.textPane.getFontMetrics(this.textPane.getFont());
        int n2 = fontMetrics.charWidth('w');
        int n3 = n2 * n;
        TabStop[] tabStopArray = new TabStop[10];
        for (int i = 0; i < tabStopArray.length; ++i) {
            int n4 = i + 1;
            tabStopArray[i] = new TabStop(n4 * n3);
        }
        TabSet tabSet = new TabSet(tabStopArray);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setTabSet(simpleAttributeSet, tabSet);
        int n5 = this.srcdoc.getLength();
        this.srcdoc.setParagraphAttributes(0, n5, simpleAttributeSet, false);
    }

    public void imprimer() {
        DocumentRenderer documentRenderer = new DocumentRenderer();
        documentRenderer.print(this.textPane);
    }

    public void rechercher() {
        if (this.dlgRecherche == null) {
            this.dlgRecherche = new DialogueRechercher(this.jframe.doc, this.textPane);
        }
        this.dlgRecherche.setVisible(true);
    }

    public void suivant() {
        if (this.dlgRecherche != null) {
            texteRecherche = this.dlgRecherche.getTexteRecherche();
            this.dlgRecherche.suivant(this.textPane.getSelectionStart());
        }
    }

    class Buffer {
        int tailleMax = 200;
        String sbuff;
        int debut;
        int fin;

        public Buffer() {
            this.lire(0);
        }

        public void lire(int n) {
            int n2 = this.tailleMax;
            if (n + n2 > SourceFrame.this.srcdoc.getLength()) {
                n2 = SourceFrame.this.srcdoc.getLength() - n;
            }
            try {
                this.sbuff = SourceFrame.this.srcdoc.getText(n, n2);
            }
            catch (BadLocationException badLocationException) {
                LOG.error("Buffer.lire: BadLocationException", badLocationException);
            }
            if (this.sbuff.length() != n2) {
                LOG.error("Buffer.lire: erreur: " + this.sbuff.length() + " != " + n2);
            }
            this.debut = n;
            this.fin = n + n2;
        }

        public char getChar(int n) {
            if (n >= SourceFrame.this.srcdoc.getLength()) {
                return ' ';
            }
            if (n >= this.fin) {
                this.lire(n);
            } else if (n < this.debut) {
                int n2 = n - this.tailleMax + 1;
                if (n2 < 0) {
                    n2 = 0;
                }
                this.lire(n2);
            }
            return this.sbuff.charAt(n - this.debut);
        }

        public boolean subEquals(String string, int n) {
            int n2;
            if (n >= SourceFrame.this.srcdoc.getLength()) {
                LOG.error("erreur dans Buffer.subEquals: ind >= srcdoc.getLength() : " + n + " >= " + SourceFrame.this.srcdoc.getLength());
            }
            if (n + (n2 = string.length()) >= SourceFrame.this.srcdoc.getLength()) {
                return false;
            }
            if (n2 > this.tailleMax) {
                LOG.error("erreur dans Buffer.subEquals: " + n2 + " > taille maxi (" + this.tailleMax + ")");
            }
            if (n < this.debut || n + n2 > this.fin) {
                this.lire(n);
            }
            int n3 = 0;
            int n4 = n - this.debut;
            while (n3 < n2) {
                if (string.charAt(n3) != this.sbuff.charAt(n4)) {
                    return false;
                }
                ++n3;
                ++n4;
            }
            return true;
        }
    }
}

