/*
 * Decompiled with CFR 0.152.
 */
package jaxe.elements;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jaxe.Balise;
import jaxe.Config;
import jaxe.DialogueAideElement;
import jaxe.ImageKeeper;
import jaxe.JaxeDocument;
import jaxe.JaxeElement;
import jaxe.VerifTypeSimple;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AffichageFormulaire
implements DocumentListener,
ItemListener {
    private static final Logger LOG = Logger.getLogger(AffichageFormulaire.class);
    private static final Color couleurErreur = new Color(200, 0, 0);
    private static final Color couleurObligatoire = new Color(150, 0, 0);
    private static final Color couleurFacultatif = new Color(0, 100, 0);
    private static final ImageIcon iconeAttributs = new ImageIcon(ImageKeeper.loadImage("images/attributs.gif", true));
    private static final int profondeurMax = 10;
    private final Element refNoeud;
    private Node noeud;
    private final boolean attribut;
    private final AffichageFormulaire affParent;
    private final JaxeDocument doc;
    private final Config cfg;
    private ArrayList<Node> enfants;
    private JComponent comp = null;
    private final VerifTypeSimple verif;
    private final ArrayList<Element> refEnfantsPossibles;
    private final ArrayList<Element> refAttributsPossibles;
    private JLabel labelTitre = null;
    private JPanel panelElement = null;
    private JPanel panelEnfants = null;
    private JPanel panelGauche = null;
    private JPanel panelDroite = null;
    private int profondeur;
    private ArrayList<AffichageFormulaire> affEnfants = null;
    private ArrayList<String> listeValeurs = null;

    public AffichageFormulaire(Element element, Element element2, AffichageFormulaire affichageFormulaire, JaxeDocument jaxeDocument) {
        this(element, element2, affichageFormulaire, jaxeDocument, false);
    }

    public AffichageFormulaire(Element element, Node node, AffichageFormulaire affichageFormulaire, JaxeDocument jaxeDocument, boolean bl) {
        this.refNoeud = element;
        this.noeud = node;
        this.affParent = affichageFormulaire;
        this.doc = jaxeDocument;
        this.cfg = jaxeDocument.cfg;
        this.attribut = bl;
        this.profondeur = affichageFormulaire == null ? 0 : affichageFormulaire.getProfondeur() + 1;
        if (!bl) {
            this.refAttributsPossibles = this.cfg.listeAttributs(element);
            this.refEnfantsPossibles = this.cfg.listeSousElements(element);
        } else {
            this.refAttributsPossibles = null;
            this.refEnfantsPossibles = null;
        }
        this.lireEnfants();
        this.verif = this.avecEnfants() ? null : this.cfg.getVerifTypeSimple(element);
    }

    private void lireEnfants() {
        if (this.attribut || this.noeud == null) {
            this.enfants = null;
            return;
        }
        this.enfants = new ArrayList();
        NamedNodeMap namedNodeMap = this.noeud.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            this.enfants.add(namedNodeMap.item(i));
        }
        NodeList nodeList = ((Element)this.noeud).getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            this.enfants.add(node);
        }
    }

    private boolean avecEnfants() {
        return this.refAttributsPossibles != null && this.refAttributsPossibles.size() > 0 || this.refEnfantsPossibles != null && this.refEnfantsPossibles.size() > 0;
    }

    public JPanel getPanel() {
        return this.getPanel(false);
    }

    private JPanel getPanel(boolean bl) {
        this.panelEnfants = new JPanel(new GridBagLayout());
        this.panelElement = new JPanel(new BorderLayout());
        if (!this.attribut && this.affParent != null && this.affParent.enfantsMultiples(this.refNoeud)) {
            JButton jButton;
            JPanel jPanel = new JPanel(new BorderLayout());
            if (bl) {
                jButton = new JButton("+");
                jButton.setAction(new AbstractAction("+"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        AffichageFormulaire.this.affParent.ajouterAffichageEnfant(AffichageFormulaire.this);
                    }
                });
                jPanel.add((Component)jButton, "West");
            }
            jButton = new JButton("-");
            jButton.setAction(new AbstractAction("-"){

                public void actionPerformed(ActionEvent actionEvent) {
                    AffichageFormulaire.this.affParent.retirerAffichageEnfant(AffichageFormulaire.this);
                }
            });
            jPanel.add((Component)jButton, "East");
            this.panelElement.add((Component)jPanel, "East");
            this.panelElement.add((Component)this.panelEnfants, "Center");
        } else {
            this.panelElement.add((Component)this.panelEnfants, "Center");
        }
        if (this.affParent != null) {
            this.panelElement.add((Component)this.getPanelTitre(), "North");
            this.panelEnfants.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.panelElement.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }
        this.majPanel(null);
        if (this.affParent == null) {
            this.panelEnfants.setFocusCycleRoot(true);
            this.panelElement = new JPanel(new BorderLayout());
            this.panelElement.setOpaque(false);
            this.panelElement.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            this.panelEnfants.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.getTitre()), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.panelElement.add((Component)this.panelEnfants, "Center");
        }
        return this.panelElement;
    }

    private JPanel getPanelTitre() {
        JButton jButton = new JButton(new ActionAide(this.refNoeud));
        jButton.setFont(jButton.getFont().deriveFont(9.0f));
        if (System.getProperty("os.name").startsWith("Mac OS")) {
            jButton.setText("?");
            if ("10.5".compareTo(System.getProperty("os.version")) <= 0) {
                jButton.putClientProperty("JButton.buttonType", "help");
            } else {
                jButton.putClientProperty("JButton.buttonType", "toolbar");
            }
        } else {
            jButton.setIcon(new ImageIcon(ImageKeeper.loadImage("images/aide.png")));
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jButton.setBorderPainted(false);
            jButton.setContentAreaFilled(false);
        }
        String string = this.getDocumentation();
        if (string != null) {
            jButton.setToolTipText(string);
        }
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        JLabel jLabel = new JLabel(this.getTitre());
        Color color = this.affParent != null ? (this.obligatoire() ? couleurObligatoire : couleurFacultatif) : this.panelEnfants.getForeground();
        jLabel.setForeground(color);
        jPanel.add(jLabel);
        jPanel.setBorder(BorderFactory.createEtchedBorder(0));
        JPanel jPanel2 = new JPanel(new FlowLayout(3, 0, 0));
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private void majPanel(Element element) {
        this.lireEnfants();
        if (this.profondeur > 10) {
            return;
        }
        this.panelEnfants.removeAll();
        this.affEnfants = new ArrayList();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        if (!this.attribut) {
            Object object;
            Object object2;
            Object object3;
            for (Element element2 : this.refAttributsPossibles) {
                Node node = null;
                if (this.enfants != null) {
                    for (Node node2 : this.enfants) {
                        if (!(node2 instanceof Attr)) continue;
                        object3 = node2.getNodeName();
                        object2 = node2.getNamespaceURI();
                        boolean bl = ((String)object3).equals(this.cfg.nomAttribut(element2));
                        object = this.cfg.espaceAttribut(element2);
                        if (!(bl = bl && (object2 == null && object == null || object2 != null && ((String)object2).equals(object)))) continue;
                        node = node2;
                    }
                }
                AffichageFormulaire affichageFormulaire = new AffichageFormulaire(element2, node, this, this.doc, true);
                this.affEnfants.add(affichageFormulaire);
                this.placerAffichage(affichageFormulaire, this.panelEnfants, gridBagConstraints, n++, false);
            }
            for (Element element2 : this.refEnfantsPossibles) {
                boolean bl = false;
                if (this.enfants != null) {
                    int n2 = this.enfants.size();
                    for (int i = 0; i < n2; ++i) {
                        Node node;
                        object3 = this.enfants.get(i);
                        if (!(object3 instanceof Element) || (object2 = this.cfg.getElementRef((Element)object3)) != element2) continue;
                        AffichageFormulaire affichageFormulaire = new AffichageFormulaire((Element)object2, (Node)object3, this, this.doc, false);
                        this.affEnfants.add(affichageFormulaire);
                        object = i + 1 < n2 ? ((node = this.enfants.get(i + 1)) instanceof Element ? this.cfg.getElementRef((Element)node) : null) : null;
                        boolean bl2 = element == null && object != object2;
                        this.placerAffichage(affichageFormulaire, this.panelEnfants, gridBagConstraints, n++, bl2);
                        bl = true;
                    }
                }
                if (bl && element2 != element) continue;
                AffichageFormulaire affichageFormulaire = new AffichageFormulaire(element2, null, this, this.doc, false);
                this.affEnfants.add(affichageFormulaire);
                this.placerAffichage(affichageFormulaire, this.panelEnfants, gridBagConstraints, n++, true);
            }
        }
    }

    private void placerAffichage(AffichageFormulaire affichageFormulaire, JPanel jPanel, GridBagConstraints gridBagConstraints, int n, boolean bl) {
        if (affichageFormulaire.avecEnfants()) {
            JPanel jPanel2 = affichageFormulaire.getPanel(bl);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            jPanel.add((Component)jPanel2, gridBagConstraints);
        } else {
            JPanel jPanel3 = affichageFormulaire.getPanelGauche();
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)jPanel3, gridBagConstraints);
            JPanel jPanel4 = affichageFormulaire.getPanelDroite(bl);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            jPanel.add((Component)jPanel4, gridBagConstraints);
        }
    }

    private JPanel getPanelGauche() {
        this.panelGauche = new JPanel(new FlowLayout(0));
        JButton jButton = new JButton(new ActionAide(this.refNoeud));
        jButton.setFont(jButton.getFont().deriveFont(9.0f));
        if (System.getProperty("os.name").startsWith("Mac OS")) {
            jButton.setText("?");
            if ("10.5".compareTo(System.getProperty("os.version")) <= 0) {
                jButton.putClientProperty("JButton.buttonType", "help");
            } else {
                jButton.putClientProperty("JButton.buttonType", "toolbar");
            }
        } else {
            jButton.setIcon(new ImageIcon(ImageKeeper.loadImage("images/aide.png")));
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jButton.setBorderPainted(false);
            jButton.setContentAreaFilled(false);
        }
        String string = this.getDocumentation();
        if (string != null) {
            jButton.setToolTipText(string);
        }
        if (string == null && this.attribut) {
            jButton.setEnabled(false);
        }
        this.panelGauche.add(jButton);
        this.labelTitre = new JLabel(this.getTitre());
        if (this.affParent != null) {
            if (this.obligatoire()) {
                this.labelTitre.setForeground(couleurObligatoire);
            } else {
                this.labelTitre.setForeground(couleurFacultatif);
            }
        }
        this.panelGauche.add(this.labelTitre);
        return this.panelGauche;
    }

    private JPanel getPanelDroite(boolean bl) {
        Serializable serializable;
        Object object;
        this.panelDroite = new JPanel(new BorderLayout());
        String string = "";
        if (this.noeud != null) {
            if (this.attribut) {
                string = this.noeud.getNodeValue();
            } else {
                object = ((Element)this.noeud).getFirstChild();
                if (object != null && object.getNodeType() == 3) {
                    string = object.getNodeValue();
                }
            }
        }
        if (this.attribut || this.cfg.contientDuTexte(this.refNoeud)) {
            object = null;
            serializable = null;
            if (this.verif != null) {
                object = this.verif.getBaseType();
                serializable = this.verif.getEnumeration();
            }
            if ("boolean".equals(object)) {
                String string2 = this.getTitre();
                JCheckBox jCheckBox = new JCheckBox(string2);
                if ("true".equals(string.trim()) || "1".equals(string.trim())) {
                    jCheckBox.setSelected(true);
                }
                jCheckBox.addItemListener(this);
                this.comp = jCheckBox;
            } else if (serializable != null) {
                Object object2;
                String string32;
                this.listeValeurs = new ArrayList<String>((Collection<String>)((Object)serializable));
                if (!this.listeValeurs.contains(string)) {
                    this.listeValeurs.add(string);
                }
                if (!this.obligatoire() && !this.listeValeurs.contains("")) {
                    this.listeValeurs.add("");
                }
                ArrayList<Object> arrayList = new ArrayList<Object>(this.listeValeurs.size());
                for (String string32 : this.listeValeurs) {
                    if (this.attribut) {
                        Element element = this.affParent.getNoeudRef();
                        object2 = this.cfg.titreValeurAttribut(element, this.refNoeud, string32);
                    } else {
                        object2 = this.cfg.titreValeurElement(this.refNoeud, string32);
                    }
                    arrayList.add(object2);
                }
                JComboBox<Object> jComboBox = new JComboBox<Object>(arrayList.toArray());
                if (this.attribut) {
                    object2 = this.affParent.getNoeudRef();
                    string32 = this.cfg.titreValeurAttribut((Element)object2, this.refNoeud, string);
                } else {
                    string32 = this.cfg.titreValeurElement(this.refNoeud, string);
                }
                jComboBox.setSelectedItem(string32);
                jComboBox.addItemListener(this);
                this.comp = jComboBox;
            } else {
                ArrayList<String> arrayList;
                ArrayList<String> arrayList2;
                if (this.attribut) {
                    arrayList2 = this.affParent.getNoeudRef();
                    arrayList = this.doc.cfg.listeValeursSuggereesAttribut((Element)((Object)arrayList2), this.refNoeud);
                } else {
                    arrayList = this.doc.cfg.listeValeursSuggereesElement(this.refNoeud);
                }
                if (arrayList != null && arrayList.size() > 0) {
                    Object object3;
                    String string42;
                    this.listeValeurs = new ArrayList<String>(arrayList);
                    if (!this.listeValeurs.contains(string)) {
                        this.listeValeurs.add(string);
                    }
                    arrayList2 = new ArrayList<String>(this.listeValeurs.size());
                    for (String string42 : this.listeValeurs) {
                        if (this.attribut) {
                            Element element = this.affParent.getNoeudRef();
                            object3 = this.cfg.titreValeurAttribut(element, this.refNoeud, string42);
                        } else {
                            object3 = this.cfg.titreValeurElement(this.refNoeud, string42);
                        }
                        arrayList2.add((String)object3);
                    }
                    JComboBox<Object> jComboBox = new JComboBox<Object>(arrayList2.toArray());
                    jComboBox.setEditable(true);
                    if (this.attribut) {
                        object3 = this.affParent.getNoeudRef();
                        string42 = this.cfg.titreValeurAttribut((Element)object3, this.refNoeud, string);
                    } else {
                        string42 = this.cfg.titreValeurElement(this.refNoeud, string);
                    }
                    jComboBox.setSelectedItem(string42);
                    jComboBox.addItemListener(this);
                    this.comp = jComboBox;
                } else {
                    arrayList2 = new JTextField(string);
                    ((JTextComponent)((Object)arrayList2)).getDocument().addDocumentListener(this);
                    this.comp = arrayList2;
                }
            }
            this.panelDroite.add((Component)this.comp, "Center");
            if (this.verif != null && !"".equals(string)) {
                this.setValidite(this.verif.estValide(string));
            }
        }
        if (!this.attribut && this.affParent != null && this.affParent.enfantsMultiples(this.refNoeud)) {
            object = new JPanel(new FlowLayout(1, 0, 0));
            if (bl) {
                serializable = new JButton("+");
                ((AbstractButton)serializable).setAction(new AbstractAction("+"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        AffichageFormulaire.this.affParent.ajouterAffichageEnfant(AffichageFormulaire.this);
                    }
                });
                ((Container)object).add((Component)serializable);
            }
            serializable = new JButton("-");
            ((AbstractButton)serializable).setAction(new AbstractAction("-"){

                public void actionPerformed(ActionEvent actionEvent) {
                    AffichageFormulaire.this.affParent.retirerAffichageEnfant(AffichageFormulaire.this);
                }
            });
            ((Container)object).add((Component)serializable);
            this.panelDroite.add((Component)object, "East");
        }
        this.panelDroite.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        return this.panelDroite;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.enregistrerChangement();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.enregistrerChangement();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.enregistrerChangement();
    }

    private void enregistrerChangement() {
        String string = this.getValeur();
        if (string == null) {
            string = "";
        }
        this.doc.setModif(true);
        if (this.noeud == null && !"".equals(string)) {
            this.creerNoeud();
        } else if (this.noeud != null && "".equals(string) && this.affParent != null) {
            this.effacerNoeud();
            return;
        }
        if (!this.attribut) {
            Element element = (Element)this.noeud;
            Node node = element.getFirstChild();
            if (node == null) {
                Text text = element.getOwnerDocument().createTextNode(string);
                element.appendChild(text);
            } else if (node.getNodeType() == 3) {
                node.setNodeValue(string);
            } else {
                LOG.error("AffichageFormulaire.enregistrerChangement : pas de noeud texte pour enregistrer le champ");
            }
        } else {
            Element element = (Element)this.affParent.getNoeud();
            String string2 = this.cfg.nomAttribut(this.refNoeud);
            String string3 = this.cfg.espaceAttribut(this.refNoeud);
            element.setAttributeNS(string3, string2, string);
        }
        if (this.verif != null) {
            this.setValidite("".equals(string) || this.verif.estValide(string));
        }
    }

    private String getValeur() {
        String string;
        if (this.comp instanceof JTextField) {
            Document document = ((JTextField)this.comp).getDocument();
            try {
                string = document.getText(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                LOG.error("lecture du champ texte", badLocationException);
                return null;
            }
        } else {
            JComboBox jComboBox;
            int n;
            string = this.comp instanceof JCheckBox ? Boolean.toString(((JCheckBox)this.comp).isSelected()) : (this.comp instanceof JComboBox ? ((n = (jComboBox = (JComboBox)this.comp).getSelectedIndex()) != -1 ? this.listeValeurs.get(jComboBox.getSelectedIndex()) : (String)jComboBox.getSelectedItem()) : null);
        }
        return string;
    }

    private void setValidite(boolean bl) {
        if (this.comp == null) {
            LOG.error("AffichageFormulaire.setValidite : pas de champ ?");
        }
        if (bl) {
            this.comp.setForeground(Color.black);
        } else {
            this.comp.setForeground(couleurErreur);
        }
    }

    private Node getNoeud() {
        return this.noeud;
    }

    private Element getNoeudRef() {
        return this.refNoeud;
    }

    private String getTitre() {
        if (this.attribut) {
            Element element = this.affParent.getNoeudRef();
            return this.cfg.titreAttribut(element, this.refNoeud);
        }
        return this.cfg.titreElement(this.refNoeud);
    }

    private String getDocumentation() {
        String string;
        if (this.attribut) {
            Element element = this.affParent.getNoeudRef();
            string = this.cfg.documentationAttribut(element, this.refNoeud);
        } else {
            string = this.cfg.documentation(this.refNoeud);
        }
        if (string != null) {
            string = "<html><body>" + string.replaceAll("\n", "<br>") + "</body></html>";
        }
        return string;
    }

    private int getProfondeur() {
        return this.profondeur;
    }

    private void creerNoeud() {
        if (this.attribut) {
            Element element = (Element)this.affParent.getNoeud();
            if (element == null) {
                this.affParent.creerNoeud();
                element = (Element)this.affParent.getNoeud();
            }
            String string = this.cfg.nomAttribut(this.refNoeud);
            String string2 = this.cfg.espaceAttribut(this.refNoeud);
            element.setAttributeNS(string2, string, "");
            this.noeud = element.getAttributeNodeNS(string2, string);
        } else {
            this.noeud = JaxeElement.nouvelElementDOM(this.doc, this.refNoeud);
            Element element = (Element)this.affParent.getNoeud();
            if (element == null) {
                this.affParent.creerNoeud();
                element = (Element)this.affParent.getNoeud();
                element.appendChild(this.noeud.getOwnerDocument().createTextNode("\n"));
            }
            Element element2 = this.affParent.trouverSuivant(this.refNoeud);
            Text text = this.noeud.getOwnerDocument().createTextNode("\n");
            if (element2 == null) {
                element.appendChild(this.noeud);
                element.appendChild(text);
            } else {
                element.insertBefore(this.noeud, element2);
                element.insertBefore(text, element2);
            }
        }
        this.affParent.lireEnfants();
        this.doc.textPane.miseAJourArbre();
    }

    private Element trouverSuivant(Element element) {
        int n = this.refEnfantsPossibles.indexOf(element);
        if (n == this.refEnfantsPossibles.size() - 1) {
            return null;
        }
        if (this.enfants == null) {
            return null;
        }
        for (Node node : this.enfants) {
            Element element2;
            int n2;
            if (!(node instanceof Element) || (n2 = this.refEnfantsPossibles.indexOf(element2 = this.cfg.getElementRef((Element)node))) <= n) continue;
            return (Element)node;
        }
        return null;
    }

    private void effacerNoeud() {
        Element element = (Element)this.affParent.getNoeud();
        if (this.attribut) {
            String string = this.cfg.nomAttribut(this.refNoeud);
            String string2 = this.cfg.espaceAttribut(this.refNoeud);
            element.removeAttributeNS(string2, string);
        } else {
            Node node = this.noeud.getNextSibling();
            element.removeChild(this.noeud);
            if (node.getNodeType() == 3) {
                element.removeChild(node);
            }
        }
        this.noeud = null;
        this.affParent.testEffacementParent();
        this.doc.textPane.miseAJourArbre();
    }

    private void testEffacementParent() {
        this.lireEnfants();
        if (this.enfants.size() == 0 && this.noeud != null && this.affParent != null) {
            this.effacerNoeud();
        }
    }

    private boolean enfantsMultiples(Element element) {
        if (this.attribut) {
            return false;
        }
        if (this.cfg.getSchema() == null) {
            return true;
        }
        return this.cfg.getSchema().enfantsMultiples(this.refNoeud, element);
    }

    private boolean obligatoire() {
        if (this.attribut) {
            return this.cfg.estObligatoire(this.refNoeud);
        }
        return this.affParent.elementObligatoire(this.refNoeud);
    }

    private boolean elementObligatoire(Element element) {
        if (this.cfg.getSchema() == null) {
            return false;
        }
        return this.cfg.getSchema().elementObligatoire(this.refNoeud, element);
    }

    private void ajouterAffichageEnfant(AffichageFormulaire affichageFormulaire) {
        this.majPanel(affichageFormulaire.getNoeudRef());
    }

    private void retirerAffichageEnfant(AffichageFormulaire affichageFormulaire) {
        if (affichageFormulaire.getNoeud() != null) {
            affichageFormulaire.effacerNoeud();
        }
        this.majPanel(null);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.enregistrerChangement();
    }

    public Point getPointEnfant(Element element) {
        if (this.noeud == element) {
            return this.getPoint();
        }
        if (this.affEnfants != null) {
            for (AffichageFormulaire affichageFormulaire : this.affEnfants) {
                Point point = affichageFormulaire.getPointEnfant(element);
                if (point == null) continue;
                Point point2 = this.getPoint();
                if (point2 != null) {
                    point.translate(point2.x, point2.y);
                }
                Point point3 = this.panelEnfants.getLocation();
                point.translate(point3.x, point3.y);
                return point;
            }
        }
        return null;
    }

    public Point getPoint() {
        if (this.panelElement != null) {
            return this.panelElement.getLocation();
        }
        if (this.panelGauche != null) {
            return this.panelGauche.getLocation();
        }
        return null;
    }

    public void selection(boolean bl) {
        if (bl) {
            this.panelEnfants.setBackground(Balise.getCouleurs()[0][1]);
        } else {
            this.panelEnfants.setBackground(null);
        }
    }

    public void majAffichage() {
    }

    class ActionAide
    extends AbstractAction {
        Element refNoeud;

        ActionAide(Element element) {
            this.refNoeud = element;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DialogueAideElement dialogueAideElement;
            if (AffichageFormulaire.this.attribut) {
                Element element = AffichageFormulaire.this.affParent.getNoeudRef();
                dialogueAideElement = new DialogueAideElement(this.refNoeud, element, AffichageFormulaire.this.cfg.getRefConf(element), (JFrame)((AffichageFormulaire)AffichageFormulaire.this).doc.textPane.getTopLevelAncestor());
            } else {
                dialogueAideElement = new DialogueAideElement(this.refNoeud, AffichageFormulaire.this.cfg.getRefConf(this.refNoeud), (JFrame)((AffichageFormulaire)AffichageFormulaire.this).doc.textPane.getTopLevelAncestor());
            }
            dialogueAideElement.setVisible(true);
        }
    }
}

