/*
 * Decompiled with CFR 0.152.
 */
package jaxe.equations;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.font.GlyphVector;
import java.util.Vector;
import jaxe.equations.element.MathRootElement;
import org.apache.log4j.Logger;

public class MathBase {
    private static final Logger LOG = Logger.getLogger(MathBase.class);
    private String fontname = "Default";
    private int fontstyle = 0;
    private int inlinefontsize = 12;
    private int displayfontsize = 14;
    private final int minfontsize = 8;
    private final int maxfontsize = 60;
    private final Font[] fonts = new Font[60];
    private FontMetrics[] fontmetrics = null;
    private final Font[] symbolFonts = new Font[60];
    private FontMetrics[] symbolFontmetrics = null;
    private boolean debug = false;
    public static final int INLINE = 0;
    public static final int DISPLAY = 1;
    private final int mode = 0;
    private MathRootElement rootElement;
    public boolean windaube;
    private final char[] Symbol_chars = new char[]{'\u239b', '\u239c', '\u239d', '\u239e', '\u239f', '\u23a0', '\u23a1', '\u23a2', '\u23a3', '\u23a4', '\u23a5', '\u23a6', '\u23a7', '\u23a8', '\u23aa', '\u23a9', '\u23ab', '\u23ac', '\u23ad', '\u2320', '\u2321', '\u2211', '\u220f'};
    private final int[] MS_Symbol_codes = new int[]{167, 168, 169, 183, 184, 185, 170, 171, 172, 186, 187, 188, 173, 174, 176, 175, 189, 190, 191, 180, 182, 166, 150};
    private final Vector<Font> goodFonts;

    public MathBase(MathRootElement mathRootElement, String string, int n, int n2, int n3, Graphics graphics) {
        this(string, n, n2, n3, graphics);
        this.setRootElement(mathRootElement);
    }

    public MathBase(MathRootElement mathRootElement, Graphics graphics) {
        this(mathRootElement, "Default", 0, 12, 14, graphics);
    }

    public MathBase(String string, int n, int n2, int n3, Graphics graphics) {
        this.fontname = string;
        this.fontstyle = n;
        this.inlinefontsize = n2;
        this.displayfontsize = n3;
        this.windaube = System.getProperty("os.name").startsWith("Windows");
        for (int i = 0; i < 60; ++i) {
            this.fonts[i] = new Font(string, n, i);
        }
        this.goodFonts = new Vector();
        String string2 = "Symbol";
        if (!this.windaube) {
            Font object = new Font("Symbol", n, n3);
            boolean bl = true;
            for (char c : this.Symbol_chars) {
                if (object.canDisplay(c)) continue;
                bl = false;
                break;
            }
            if (!bl) {
                LOG.error("MathBase(String, int, int, int) - Warning: Symbol does not have all the necessary glyphs");
                Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
                Font font = null;
                Font font2 = null;
                int n4 = 1000;
                for (int i = 0; i < fontArray.length && font == null; ++i) {
                    int n5;
                    object = fontArray[i];
                    int n6 = 0;
                    for (char c : this.Symbol_chars) {
                        if (object.canDisplay(c)) continue;
                        ++n6;
                    }
                    if (n6 == 0) {
                        font = object;
                    }
                    if (n6 >= n5) continue;
                    font2 = object;
                    n5 = n6;
                }
                if (font == null) {
                    LOG.error("MathBase(String, int, int, int) - Error: no font on this system has all the necessary glyphs");
                    string2 = font2.getName();
                } else {
                    string2 = font.getName();
                }
                LOG.error("MathBase(String, int, int, int) - Using a different font: " + string2);
            }
        }
        this.goodFonts.add(new Font(string2, 0, n3));
        for (int i = 0; i < 60; ++i) {
            this.symbolFonts[i] = new Font(string2, n, i);
        }
        if (graphics != null) {
            this.setupFontMetrics(graphics);
        }
    }

    private void setupFontMetrics(Graphics graphics) {
        int n;
        this.fontmetrics = new FontMetrics[60];
        for (n = 0; n < 60; ++n) {
            this.fontmetrics[n] = graphics.getFontMetrics(this.fonts[n]);
        }
        this.symbolFontmetrics = new FontMetrics[60];
        for (n = 0; n < 60; ++n) {
            this.symbolFontmetrics[n] = graphics.getFontMetrics(this.symbolFonts[n]);
        }
    }

    public void setRootElement(MathRootElement mathRootElement) {
        if (mathRootElement == null) {
            return;
        }
        this.rootElement = mathRootElement;
        this.rootElement.setMathBase(this);
        if (mathRootElement.getMode() == 1) {
            this.rootElement.setFontSize(this.displayfontsize);
        } else {
            this.rootElement.setFontSize(this.inlinefontsize);
        }
        this.rootElement.setDebug(this.isDebug());
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
        if (this.rootElement != null) {
            this.rootElement.setDebug(bl);
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDefaultFontSize(int n) {
        if (n >= 8 || n < 60) {
            this.inlinefontsize = n;
        }
    }

    public int getDefaultInlineFontSize() {
        return this.inlinefontsize;
    }

    public void setDefaultDisplayFontSize(int n) {
        if (n >= 8 || n < 60) {
            this.displayfontsize = n;
        }
    }

    public int getDefaultDisplayFontSize() {
        return this.displayfontsize;
    }

    public Font getFont(int n) {
        if (n < 8) {
            return this.fonts[8];
        }
        if (n > 60) {
            return this.fonts[59];
        }
        return this.fonts[n];
    }

    public Font getSymbolFont(int n) {
        if (n < 8) {
            return this.symbolFonts[8];
        }
        if (n > 60) {
            return this.symbolFonts[59];
        }
        return this.symbolFonts[n];
    }

    public String findFont(String string, Font font) {
        Font font2;
        if (this.goodFonts != null) {
            font2 = this.goodFonts.iterator();
            while (font2.hasNext()) {
                Font font3 = (Font)font2.next();
                int n = font3.canDisplayUpTo(string);
                if (n != -1 && n != string.length()) continue;
                return font3.getName();
            }
        }
        for (Object object : font2 = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            int n = ((Font)object).canDisplayUpTo(string);
            if (n != -1 && n != string.length()) continue;
            this.goodFonts.add((Font)object);
            return ((Font)object).getName();
        }
        return font.getName();
    }

    public FontMetrics getFontMetrics(int n) {
        if (n < 8) {
            return this.fontmetrics[8];
        }
        if (n > 60) {
            return this.fontmetrics[59];
        }
        return this.fontmetrics[n];
    }

    public FontMetrics getSymbolFontMetrics(int n) {
        if (n < 8) {
            return this.symbolFontmetrics[8];
        }
        if (n > 60) {
            return this.symbolFontmetrics[59];
        }
        return this.symbolFontmetrics[n];
    }

    public GlyphVector getSymbolGlyphVector(Graphics2D graphics2D, int n, char c) {
        String string;
        if (this.windaube) {
            int n2 = 0;
            for (int i = 0; i < this.Symbol_chars.length; ++i) {
                if (this.Symbol_chars[i] != c) continue;
                n2 = this.MS_Symbol_codes[i];
                break;
            }
            if (n2 == 0) {
                if (n < 8) {
                    return this.symbolFonts[8].createGlyphVector(graphics2D.getFontRenderContext(), new char[]{c});
                }
                if (n > 60) {
                    return this.symbolFonts[59].createGlyphVector(graphics2D.getFontRenderContext(), new char[]{c});
                }
                return this.symbolFonts[n].createGlyphVector(graphics2D.getFontRenderContext(), new char[]{c});
            }
            if (n < 8) {
                return this.symbolFonts[8].createGlyphVector(graphics2D.getFontRenderContext(), new int[]{n2});
            }
            if (n > 60) {
                return this.symbolFonts[59].createGlyphVector(graphics2D.getFontRenderContext(), new int[]{n2});
            }
            return this.symbolFonts[n].createGlyphVector(graphics2D.getFontRenderContext(), new int[]{n2});
        }
        if (n < 8) {
            n = 8;
        } else if (n > 60) {
            n = 59;
        }
        Font font = this.symbolFonts[n];
        if (!font.canDisplay(c) && !(string = this.findFont(Character.toString(c), font)).equals(font.getName())) {
            font = new Font(string, 0, n);
        }
        return font.createGlyphVector(graphics2D.getFontRenderContext(), new char[]{c});
    }

    public void paint(Graphics graphics) {
        if (this.fontmetrics == null) {
            this.setupFontMetrics(graphics);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.rootElement != null) {
            this.rootElement.paint(graphics);
        }
    }

    public int getWidth() {
        if (this.rootElement != null) {
            return this.rootElement.getWidth();
        }
        return 0;
    }

    public int getHeight() {
        if (this.rootElement != null) {
            return this.rootElement.getHeight();
        }
        return 0;
    }
}

