/*
 * Decompiled with CFR 0.152.
 */
package jaxe.equations;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JPanel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jaxe.equations.DOMMathBuilder;
import jaxe.equations.MathBase;
import jaxe.equations.StringMathBuilder;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class MathComponent
extends JPanel {
    private static final Logger LOG = Logger.getLogger(MathComponent.class);
    private MathBase base;

    public MathComponent(String string) {
        this.base = new MathBase(new StringMathBuilder(string).getMathRootElement(), null);
    }

    public MathComponent(Document document, int n) {
        this.base = new MathBase(new DOMMathBuilder(document).getMathRootElement(), "Default", 0, n, n, null);
    }

    public MathComponent(Document document) {
        this.base = new MathBase(new DOMMathBuilder(document).getMathRootElement(), null);
    }

    public void setMathBase(MathBase mathBase) {
        this.base = mathBase;
        this.invalidate();
    }

    public void setEquationString(String string) {
        this.base.setRootElement(new StringMathBuilder(string).getMathRootElement());
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.base.paint(graphics);
    }

    public void setDebug(boolean bl) {
        this.base.setDebug(bl);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.base.getWidth(), this.base.getHeight());
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public static void main(String[] stringArray) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new File(stringArray[0]));
            Frame frame = new Frame("Test MathComponent");
            frame.setLayout(new BorderLayout());
            MathComponent mathComponent = new MathComponent(document, 14);
            mathComponent.setDebug(false);
            frame.add((Component)mathComponent, "Center");
            frame.setVisible(true);
            frame.pack();
            frame.invalidate();
            frame.validate();
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
        }
        catch (SAXException sAXException) {
            LOG.error("main(String[])", sAXException);
        }
        catch (IOException iOException) {
            LOG.error("main(String[])", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOG.error("main(String[])", parserConfigurationException);
        }
    }
}

