/*
 * Decompiled with CFR 0.152.
 */
package gr.spinellis.ckjm;

import gr.spinellis.ckjm.ClassMetrics;
import gr.spinellis.ckjm.ClassMetricsContainer;
import gr.spinellis.ckjm.MethodVisitor;
import gr.spinellis.ckjm.MetricsFilter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;

public class ClassVisitor
extends EmptyVisitor {
    private JavaClass visitedClass;
    private ConstantPoolGen cp;
    private String myClassName;
    private ClassMetricsContainer cmap;
    private ClassMetrics cm;
    private HashSet<String> efferentCoupledClasses = new HashSet();
    private HashSet<String> responseSet = new HashSet();
    ArrayList<TreeSet<String>> mi = new ArrayList();

    public ClassVisitor(JavaClass javaClass, ClassMetricsContainer classMetricsContainer) {
        this.visitedClass = javaClass;
        this.cp = new ConstantPoolGen(this.visitedClass.getConstantPool());
        this.cmap = classMetricsContainer;
        this.myClassName = javaClass.getClassName();
        this.cm = this.cmap.getMetrics(this.myClassName);
    }

    public ClassMetrics getMetrics() {
        return this.cm;
    }

    public void start() {
        this.visitJavaClass(this.visitedClass);
    }

    public void visitJavaClass(JavaClass javaClass) {
        String string = javaClass.getSuperclassName();
        String string2 = javaClass.getPackageName();
        this.cm.setVisited();
        if (javaClass.isPublic()) {
            this.cm.setPublic();
        }
        ClassMetrics classMetrics = this.cmap.getMetrics(string);
        classMetrics.incNoc();
        if (!javaClass.getClassName().equals("java.lang.Object")) {
            this.cm.setParent(classMetrics);
        }
        this.registerCoupling(string);
        String[] stringArray = javaClass.getInterfaceNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.registerCoupling(stringArray[i]);
        }
        Field[] fieldArray = javaClass.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            fieldArray[i].accept(this);
        }
        Method[] methodArray = javaClass.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            methodArray[i].accept(this);
        }
    }

    public void registerCoupling(String string) {
        if (!(!MetricsFilter.isJdkIncluded() && ClassMetrics.isJdkClass(string) || this.myClassName.equals(string))) {
            this.efferentCoupledClasses.add(string);
            this.cmap.getMetrics(string).addAfferentCoupling(this.myClassName);
        }
    }

    public void registerCoupling(Type type) {
        this.registerCoupling(ClassVisitor.className(type));
    }

    void registerFieldAccess(String string, String string2) {
        this.registerCoupling(string);
        if (string.equals(this.myClassName)) {
            this.mi.get(this.mi.size() - 1).add(string2);
        }
    }

    void registerMethodInvocation(String string, String string2, Type[] typeArray) {
        this.registerCoupling(string);
        this.incRFC(string, string2, typeArray);
    }

    public void visitField(Field field) {
        this.registerCoupling(field.getType());
    }

    private void incRFC(String string, String string2, Type[] typeArray) {
        String string3 = Arrays.asList(typeArray).toString();
        String string4 = string3.substring(1, string3.length() - 1);
        String string5 = string + "." + string2 + "(" + string4 + ")";
        this.responseSet.add(string5);
    }

    public void visitMethod(Method method) {
        MethodGen methodGen = new MethodGen(method, this.visitedClass.getClassName(), this.cp);
        Type type = methodGen.getReturnType();
        Type[] typeArray = methodGen.getArgumentTypes();
        this.registerCoupling(methodGen.getReturnType());
        for (int i = 0; i < typeArray.length; ++i) {
            this.registerCoupling(typeArray[i]);
        }
        String[] stringArray = methodGen.getExceptions();
        for (int i = 0; i < stringArray.length; ++i) {
            this.registerCoupling(stringArray[i]);
        }
        this.incRFC(this.myClassName, method.getName(), typeArray);
        this.cm.incWmc();
        if (Modifier.isPublic(method.getModifiers())) {
            this.cm.incNpm();
        }
        this.mi.add(new TreeSet());
        MethodVisitor methodVisitor = new MethodVisitor(methodGen, this);
        methodVisitor.start();
    }

    static String className(Type type) {
        String string = type.toString();
        if (type.getType() <= 12) {
            return "java.PRIMITIVE";
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return ClassVisitor.className(arrayType.getBasicType());
        }
        return type.toString();
    }

    public void end() {
        this.cm.setCbo(this.efferentCoupledClasses.size());
        this.cm.setRfc(this.responseSet.size());
        int n = 0;
        for (int i = 0; i < this.mi.size(); ++i) {
            for (int j = i + 1; j < this.mi.size(); ++j) {
                TreeSet treeSet = (TreeSet)this.mi.get(i).clone();
                treeSet.retainAll((Collection)this.mi.get(j));
                if (treeSet.size() == 0) {
                    ++n;
                    continue;
                }
                --n;
            }
        }
        this.cm.setLcom(n > 0 ? n : 0);
    }
}

