/*
 * Decompiled with CFR 0.152.
 */
package gr.spinellis.ckjm;

import gr.spinellis.ckjm.ClassMetrics;
import gr.spinellis.ckjm.ClassVisitor;
import org.apache.bcel.generic.ArrayInstruction;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ConstantPushInstruction;
import org.apache.bcel.generic.EmptyVisitor;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.Type;

class MethodVisitor
extends EmptyVisitor {
    private MethodGen mg;
    private ConstantPoolGen cp;
    private ClassVisitor cv;
    private ClassMetrics cm;

    MethodVisitor(MethodGen methodGen, ClassVisitor classVisitor) {
        this.mg = methodGen;
        this.cv = classVisitor;
        this.cp = this.mg.getConstantPool();
        this.cm = this.cv.getMetrics();
    }

    public void start() {
        if (!this.mg.isAbstract() && !this.mg.isNative()) {
            for (InstructionHandle instructionHandle = this.mg.getInstructionList().getStart(); instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
                Instruction instruction = instructionHandle.getInstruction();
                if (this.visitInstruction(instruction)) continue;
                instruction.accept(this);
            }
            this.updateExceptionHandlers();
        }
    }

    private boolean visitInstruction(Instruction instruction) {
        short s = instruction.getOpcode();
        return InstructionConstants.INSTRUCTIONS[s] != null && !(instruction instanceof ConstantPushInstruction) && !(instruction instanceof ReturnInstruction);
    }

    public void visitLocalVariableInstruction(LocalVariableInstruction localVariableInstruction) {
        if (localVariableInstruction.getOpcode() != 132) {
            this.cv.registerCoupling(localVariableInstruction.getType(this.cp));
        }
    }

    public void visitArrayInstruction(ArrayInstruction arrayInstruction) {
        this.cv.registerCoupling(arrayInstruction.getType(this.cp));
    }

    public void visitFieldInstruction(FieldInstruction fieldInstruction) {
        this.cv.registerFieldAccess(fieldInstruction.getClassName(this.cp), fieldInstruction.getFieldName(this.cp));
        this.cv.registerCoupling(fieldInstruction.getFieldType(this.cp));
    }

    public void visitInvokeInstruction(InvokeInstruction invokeInstruction) {
        Type[] typeArray = invokeInstruction.getArgumentTypes(this.cp);
        for (int i = 0; i < typeArray.length; ++i) {
            this.cv.registerCoupling(typeArray[i]);
        }
        this.cv.registerCoupling(invokeInstruction.getReturnType(this.cp));
        this.cv.registerMethodInvocation(invokeInstruction.getClassName(this.cp), invokeInstruction.getMethodName(this.cp), typeArray);
    }

    public void visitINSTANCEOF(INSTANCEOF iNSTANCEOF) {
        this.cv.registerCoupling(iNSTANCEOF.getType(this.cp));
    }

    public void visitCHECKCAST(CHECKCAST cHECKCAST) {
        this.cv.registerCoupling(cHECKCAST.getType(this.cp));
    }

    public void visitReturnInstruction(ReturnInstruction returnInstruction) {
        this.cv.registerCoupling(returnInstruction.getType(this.cp));
    }

    private void updateExceptionHandlers() {
        CodeExceptionGen[] codeExceptionGenArray = this.mg.getExceptionHandlers();
        for (int i = 0; i < codeExceptionGenArray.length; ++i) {
            ObjectType objectType = codeExceptionGenArray[i].getCatchType();
            if (objectType == null) continue;
            this.cv.registerCoupling(objectType);
        }
    }
}

