/*
 * Decompiled with CFR 0.152.
 */
package gr.spinellis.ckjm;

import gr.spinellis.ckjm.CkjmOutputHandler;
import gr.spinellis.ckjm.ClassMetricsContainer;
import gr.spinellis.ckjm.ClassVisitor;
import gr.spinellis.ckjm.PrintPlainResults;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;

public class MetricsFilter {
    private static boolean includeJdk = false;
    private static boolean onlyPublic = false;

    public static boolean isJdkIncluded() {
        return includeJdk;
    }

    public static boolean includeAll() {
        return !onlyPublic;
    }

    static void processClass(ClassMetricsContainer classMetricsContainer, String string) {
        Object object;
        JavaClass javaClass = null;
        int n = string.indexOf(32);
        if (n != -1) {
            object = string.substring(0, n);
            string = string.substring(n + 1);
            try {
                javaClass = new ClassParser((String)object, string).parse();
            }
            catch (IOException iOException) {
                System.err.println("Error loading " + string + " from " + (String)object + ": " + iOException);
            }
        } else {
            try {
                javaClass = new ClassParser(string).parse();
            }
            catch (IOException iOException) {
                System.err.println("Error loading " + string + ": " + iOException);
            }
        }
        if (javaClass != null) {
            object = new ClassVisitor(javaClass, classMetricsContainer);
            ((ClassVisitor)object).start();
            ((ClassVisitor)object).end();
        }
    }

    public static void runMetrics(String[] stringArray, CkjmOutputHandler ckjmOutputHandler) {
        ClassMetricsContainer classMetricsContainer = new ClassMetricsContainer();
        for (int i = 0; i < stringArray.length; ++i) {
            MetricsFilter.processClass(classMetricsContainer, stringArray[i]);
        }
        classMetricsContainer.printMetrics(ckjmOutputHandler);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        if (stringArray.length > n && stringArray[n].equals("-s")) {
            includeJdk = true;
            ++n;
        }
        if (stringArray.length > n && stringArray[n].equals("-p")) {
            onlyPublic = true;
            ++n;
        }
        ClassMetricsContainer classMetricsContainer = new ClassMetricsContainer();
        if (stringArray.length == n) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    MetricsFilter.processClass(classMetricsContainer, string);
                }
            }
            catch (Exception exception) {
                System.err.println("Error reading line: " + exception);
                System.exit(1);
            }
        }
        for (int i = n; i < stringArray.length; ++i) {
            MetricsFilter.processClass(classMetricsContainer, stringArray[i]);
        }
        PrintPlainResults printPlainResults = new PrintPlainResults(System.out);
        classMetricsContainer.printMetrics(printPlainResults);
    }
}

