/*
 * Decompiled with CFR 0.152.
 */
package gr.spinellis.ckjm.ant;

import gr.spinellis.ckjm.MetricsFilter;
import gr.spinellis.ckjm.PrintPlainResults;
import gr.spinellis.ckjm.ant.PrintXmlResults;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class CkjmTask
extends MatchingTask {
    private File outputFile;
    private File classDir;
    private String format = "plain";

    public void setFormat(String string) {
        this.format = string;
    }

    public void setOutputfile(File file) {
        this.outputFile = file;
    }

    public void setClassdir(File file) {
        this.classDir = file;
    }

    public void execute() throws BuildException {
        if (this.classDir == null) {
            throw new BuildException("classdir attribute must be set!");
        }
        if (!this.classDir.exists()) {
            throw new BuildException("classdir does not exist!");
        }
        if (!this.classDir.isDirectory()) {
            throw new BuildException("classdir is not a directory!");
        }
        DirectoryScanner directoryScanner = super.getDirectoryScanner(this.classDir);
        String[] stringArray = directoryScanner.getIncludedFiles();
        if (stringArray.length == 0) {
            this.log("No class files in specified directory " + this.classDir);
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.classDir.getPath() + File.separatorChar + stringArray[i];
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.outputFile);
                if (this.format.equals("xml")) {
                    PrintXmlResults printXmlResults = new PrintXmlResults(new PrintStream(fileOutputStream));
                    printXmlResults.printHeader();
                    MetricsFilter.runMetrics(stringArray, printXmlResults);
                    printXmlResults.printFooter();
                } else {
                    PrintPlainResults printPlainResults = new PrintPlainResults(new PrintStream(fileOutputStream));
                    MetricsFilter.runMetrics(stringArray, printPlainResults);
                }
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                throw new BuildException("Error file handling: " + iOException.getMessage());
            }
        }
    }
}

