/*
 * $Id: ClassMetricsContainer.java 1.9 2005/08/10 16:53:36 dds Exp $
 *
 * (C) Copyright 2005 Diomidis Spinellis
 *
 * Permission to use, copy, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

package com.oometer.smdl;

import java.util.*;

public class ClassMetricsContainer
{

	private HashMap<String, ClassMetrics> m = new HashMap<String, ClassMetrics>();


	public ClassMetrics getMetrics(String name)
	{
		ClassMetrics cm = m.get(name);
		if (cm == null)
		{
			cm = new ClassMetrics(name);
			m.put(name, cm);
		}
		return cm;
	}

	/**
	 * Return a class's metrics
	 * @return class's metrics in 2D array form
	 */
	public Object[][] getMetricsArray()
	{
		Object[] classMetricses = m.values().toArray();
		Object[][] metricsArray = new Object[classMetricses.length][ClassMetrics.getNumberOfMetrics()];
		for (int i =0; i < classMetricses.length; i++)
		{
			ClassMetrics cm = (ClassMetrics)classMetricses[i];
			//if (cm.isVisited() && (MetricsCalculator.includeAll() || cm.isPublic()))
				metricsArray[i] = cm.toArray();
		}
		return metricsArray;
	}

	/**
	 * Print the metrics of all the visited classes.
	 * @param handler output stream handler
	 */
	public void printMetrics(OutputHandler handler)
	{
		Set<Map.Entry<String, ClassMetrics>> entries = m.entrySet();
		Iterator<Map.Entry<String, ClassMetrics>> i;

		for (i = entries.iterator(); i.hasNext();)
		{
			Map.Entry<String, ClassMetrics> e = i.next();
			ClassMetrics cm = e.getValue();
			if (cm.isVisited() && (MetricsCalculator.includeAll() || cm.isPublic()))
				handler.handleClass(e.getKey(), cm);
		}
	}
}
