/*
 * $Id: MetricsCalculator.java 1.9 2005/08/10 16:53:36 dds Exp $
 *
 * (C) Copyright 2005 Diomidis Spinellis
 *
 * Permission to use, copy, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

package com.oometer.smdl;


import org.apache.bcel.classfile.*;
import org.apache.bcel.generic.*;

import java.io.*;

public class MetricsCalculator
{

	private static boolean includeJdk = false;

	private static boolean onlyPublic = false;



	public static boolean isJdkIncluded()
	{
		return includeJdk;
	}


	public static boolean includeAll()
	{
		return !onlyPublic;
	}


	public static void processClass(ClassMetricsContainer cm, String clspec)
	{
		int spc;
		JavaClass jc = null;

		if ((spc = clspec.indexOf(' ')) != -1)
		{
			String jar = clspec.substring(0, spc);
			clspec = clspec.substring(spc + 1);
			try
			{
				jc = new ClassParser(jar, clspec).parse();
			}
			catch (IOException e)
			{
				System.err.println("Error loading " + clspec + " from " + jar + ": " + e);
			}
		}
		else
		{
			try
			{
				jc = new ClassParser(clspec).parse();
			}
			catch (IOException e)
			{
				System.err.println("Error loading " + clspec + ": " + e);
			}
		}
		if (jc != null)
		{
			ClassVisitor visitor = new ClassVisitor(jc, cm);
			visitor.start();
			visitor.end();
		}
	}


	public static void runMetrics(String[] files, OutputHandler outputHandler)
	{
		ClassMetricsContainer cm = new ClassMetricsContainer();

		for (String file : files)
			processClass(cm, file);
		cm.printMetrics(outputHandler);
	}


	public static void main(String[] argv)
	{
		int argp = 0;

		if (argv.length > argp && argv[argp].equals("-s"))
		{
			includeJdk = true;
			argp++;
		}
		if (argv.length > argp && argv[argp].equals("-p"))
		{
			onlyPublic = true;
			argp++;
		}
		ClassMetricsContainer cm = new ClassMetricsContainer();

		if (argv.length == argp)
		{
			BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
			try
			{
				String s;
				while ((s = in.readLine()) != null)
					processClass(cm, s);
			}
			catch (Exception e)
			{
				System.err.println("Error reading line: " + e);
				System.exit(1);
			}
		}

		for (int i = argp; i < argv.length; i++)
			processClass(cm, argv[i]);

		OutputHandler handler = new PrintPlainResults(System.out);
		cm.printMetrics(handler);
	}
}
