package com.oometer.smdl.gui;

import com.oometer.smdl.ClassMetrics;
import com.oometer.smdl.ClassMetricsContainer;
import com.oometer.smdl.MetricsCalculator;

import javax.swing.*;
import javax.swing.table.DefaultTableModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class MainForm
{
    private JButton openClassFilesButton;
    private JList lstClasses;
    private JPanel panel;
    private JTable tblMetrics;
    private JTabbedPane tabs;
    private JTextArea txtSMDL;
    private JButton btnBrowseSMDL;

    public MainForm()
    {
        openClassFilesButton.addActionListener(
                new ActionListener()
                {
                    public void actionPerformed(ActionEvent e)
                    {
                        JFileChooser chooser = new JFileChooser();

                        chooser.setMultiSelectionEnabled(true);

                        chooser.showOpenDialog(lstClasses);

                        File[] files = chooser.getSelectedFiles();
                        String[] filePathes = new String[files.length];
                        for (int i = 0; i < files.length; i++)
                        {
                            filePathes[i] = files[i].getAbsolutePath();
                        }
                        lstClasses.setListData(filePathes);

                        ClassMetricsContainer cm = new ClassMetricsContainer();
                        for (String filePath : filePathes)
                        {
                            MetricsCalculator.processClass(cm, filePath);
                        }

                        Object[][] objects = cm.getMetricsArray();
                        DefaultTableModel tm = new DefaultTableModel(objects, ClassMetrics.getMetricsNames());
                        tblMetrics.setModel(tm);

                    }
                });


        btnBrowseSMDL.addActionListener(
                new ActionListener()
                {
                    public void actionPerformed(ActionEvent e)
                    {
                        JFileChooser chooser = new JFileChooser();

                        chooser.setMultiSelectionEnabled(true);

                        chooser.showOpenDialog(lstClasses);

                        File[] files = chooser.getSelectedFiles();
                        String[] filePathes = new String[files.length];
                        for (int i = 0; i < files.length; i++)
                        {
                            filePathes[i] = files[i].getAbsolutePath();
                        }
                        lstClasses.setListData(filePathes);

                        ClassMetricsContainer cm = new ClassMetricsContainer();
                        for (String filePath : filePathes)
                        {
                            MetricsCalculator.processClass(cm, filePath);
                        }

                        Object[][] objects = cm.getMetricsArray();
                        DefaultTableModel tm = new DefaultTableModel(objects, ClassMetrics.getMetricsNames());
                        tblMetrics.setModel(tm);

                    }
                });
    }

    public static void main(String[] args)
    {
        MainForm form = new MainForm();
        JFrame frame = new JFrame("Metrics Calculator");
        frame.setContentPane(form.panel);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.pack();
        frame.setVisible(true);
    }
}
