/**
 * SchemaInt.java
 *
 * This file was generated by XMLSpy 2007 Enterprise Edition.
 *
 * YOU SHOULD NOT MODIFY THIS FILE, BECAUSE IT WILL BE
 * OVERWRITTEN WHEN YOU RE-RUN CODE GENERATION.
 *
 * Refer to the XMLSpy Documentation for further details.
 * http://www.parser.com/xmlspy
 */


package com.parser.types;

import java.math.BigInteger;
import java.math.BigDecimal;

public class SchemaInt implements SchemaTypeNumber {
  protected int value;
  protected boolean isempty;
  protected boolean isnull;

  // construction
  public SchemaInt() {
    setEmpty();
  }

  public SchemaInt(SchemaInt newvalue) {
    value = newvalue.value;
    isempty = newvalue.isempty;
    isnull = newvalue.isnull;
  }

  public SchemaInt(int newvalue) {
    setValue( newvalue );
  }

  public SchemaInt(String newvalue) {
    parse( newvalue );
  }

  public SchemaInt(SchemaType newvalue) {
    assign( newvalue );
  }

  public SchemaInt(SchemaTypeNumber newvalue) {
    assign( (SchemaType)newvalue );
  }

  // getValue, setValue
  public int getValue() {
    return value;
  }

  public void setValue(int newvalue) {
    value = newvalue;
    isempty = false;
    isnull = false;
  }

  public void parse(String newvalue) {
    if( newvalue == null )
      setNull();
    else if( newvalue.length() == 0)
      setEmpty();
    else {
      try {
        value = Integer.parseInt(newvalue);
        isempty = false;
        isnull = false;
      } catch( NumberFormatException e ) {
        throw new StringParseException(e);
      }
    }
  }

  public void assign(SchemaType newvalue) {
    if( newvalue == null || newvalue.isNull() )
      setNull();
    else if( newvalue.isEmpty() )
      setEmpty();
    else if( newvalue instanceof SchemaTypeNumber ) {
      value = ( (SchemaTypeNumber) newvalue).intValue();
      isempty = false;
      isnull = false;
    }
    else
      throw new TypesIncompatibleException(newvalue, this);
  }

  public void setNull() {
    isnull = true;
    isempty = true;
    value = 0;
  }

  public void setEmpty() {
    isnull = false;
    isempty = true;
    value = 0;
  }

  // further
  public int hashCode() {
    return value;
  }

  public boolean equals(Object obj) {
    if (! (obj instanceof SchemaInt))
      return false;
    return value == ( (SchemaInt) obj).value;
  }

  public Object clone() {
    return new SchemaInt( this );
  }

  public String toString() {
    if( isempty || isnull )
      return "";
    return Integer.toString(value);
  }

  public int length() {
    return toString().length();
  }

  public boolean booleanValue() {
    return value != 0;
  }

  public boolean isEmpty() {
    return isempty;
  }

  public boolean isNull() {
    return isnull;
  }

  public int compareTo(Object obj) {
    return compareTo( (SchemaInt) obj);
  }

  public int compareTo(SchemaInt obj) {
    return new Integer(value).compareTo(new Integer(obj.value));
  }

  // interface SchemaTypeNumber
  public int numericType() {
    return NUMERIC_VALUE_INT;
  }

  public int intValue() {
    return value;
  }

  public long longValue() {
    return value;
  }

  public BigInteger bigIntegerValue() {
    return BigInteger.valueOf(value);
  }

  public float floatValue() {
    return value;
  }

  public double doubleValue() {
    return value;
  }

  public BigDecimal bigDecimalValue() {
    return BigDecimal.valueOf(value);
  }
}
